/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.jndi.binder;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.ejb3.jndi.binder.impl.View;
import org.jboss.ejb3.jndi.binder.metadata.SessionBeanType;
import org.jboss.ejb3.jndi.binder.spi.ProxyFactory;
import org.jboss.logging.Logger;
import org.jboss.reloaded.naming.spi.JavaEEApplication;
import org.jboss.reloaded.naming.spi.JavaEEModule;
import org.jboss.util.naming.Util;

public class EJBBinder {
    private static final Logger log = Logger.getLogger(EJBBinder.class);
    private SessionBeanType bean;
    private Context globalContext;
    private ProxyFactory proxyFactory;
    private Collection<View> views = new LinkedList<View>();

    public EJBBinder(SessionBeanType bean) {
        this.bean = bean;
        EJBBinder.constructViews(this.views, bean.getBusinessLocals(), View.Type.BUSINESS_LOCAL, bean);
        EJBBinder.constructViews(this.views, bean.getBusinessRemotes(), View.Type.BUSINESS_REMOTE, bean);
        EJBBinder.constructView(this.views, bean.getHome(), View.Type.HOME, bean);
        EJBBinder.constructView(this.views, bean.getLocalHome(), View.Type.LOCAL_HOME, bean);
        if (bean.isLocalBean()) {
            this.views.add(new View(bean.getEJBClass(), View.Type.LOCAL_BEAN, bean));
        }
    }

    private static void constructViews(Collection<View> views, Collection<Class<?>> businessInterfaces, View.Type type, SessionBeanType bean) {
        if (businessInterfaces == null) {
            return;
        }
        for (Class<?> businessInterface : businessInterfaces) {
            views.add(new View(businessInterface, type, bean));
        }
    }

    private static void constructView(Collection<View> views, Class<?> businessInterface, View.Type type, SessionBeanType bean) {
        if (businessInterface == null) {
            return;
        }
        HashSet businessInterfaces = new HashSet();
        businessInterfaces.add(businessInterface);
        EJBBinder.constructViews(views, businessInterfaces, type, bean);
    }

    public void bind() throws NamingException {
        for (View view : this.views) {
            Object proxy = this.proxyFactory.produce(view);
            this.bindGlobal(view, proxy);
            this.bindApp(view, proxy);
            this.bindModule(view, proxy);
        }
    }

    protected void bind(Context ctx, String name, Object obj) throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Binding " + obj + " at " + name + " under " + ctx));
        }
        Util.bind((Context)ctx, (String)name, (Object)obj);
    }

    protected void bindApp(View view, Object proxy) throws NamingException {
        String name = this.getAppJNDIName(view.getBusinessInterface());
        this.bind(this.bean.getModule().getApplication().getContext(), name, proxy);
        if (this.hasSingleView()) {
            this.bind(this.bean.getModule().getApplication().getContext(), this.getAppJNDIName(null), proxy);
        }
    }

    protected void bindGlobal(View view, Object proxy) throws NamingException {
        this.bind(this.globalContext, this.getGlobalJNDIName(view.getBusinessInterface()), proxy);
        if (this.hasSingleView()) {
            this.bind(this.globalContext, this.getGlobalJNDIName(null), proxy);
        }
    }

    protected void bindModule(View view, Object proxy) throws NamingException {
        this.bind(this.bean.getModule().getContext(), this.getModuleJNDIName(view.getBusinessInterface()), proxy);
        if (this.hasSingleView()) {
            this.bind(this.bean.getModule().getContext(), this.getModuleJNDIName(null), proxy);
        }
    }

    protected String getAppJNDIName(Class<?> businessInterface) {
        JavaEEModule module = this.bean.getModule();
        return module.getName() + "/" + this.getModuleJNDIName(businessInterface);
    }

    protected String getGlobalJNDIName(Class<?> businessInterface) {
        JavaEEModule module = this.bean.getModule();
        JavaEEApplication app = module.getApplication();
        String appName = app.isEnterpriseApplicationArchive() ? app.getName() : null;
        return (appName != null ? appName + "/" : "") + this.getAppJNDIName(businessInterface);
    }

    protected String getModuleJNDIName(Class<?> businessInterface) {
        return this.bean.getName() + (businessInterface != null ? "!" + businessInterface.getName() : "");
    }

    public void setGlobalContext(Context context) {
        this.globalContext = context;
    }

    public void setProxyFactory(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void unbind() throws NamingException {
        for (View view : this.views) {
            this.unbindModule(view);
            this.unbindApp(view);
            this.unbindGlobal(view);
        }
    }

    protected void unbindApp(View view) throws NamingException {
        this.bean.getModule().getApplication().getContext().unbind(this.getAppJNDIName(view.getBusinessInterface()));
        if (this.hasSingleView()) {
            this.bean.getModule().getApplication().getContext().unbind(this.getAppJNDIName(null));
        }
    }

    protected void unbindGlobal(View view) throws NamingException {
        this.globalContext.unbind(this.getGlobalJNDIName(view.getBusinessInterface()));
        if (this.hasSingleView()) {
            this.globalContext.unbind(this.getGlobalJNDIName(null));
        }
    }

    protected void unbindModule(View view) throws NamingException {
        this.bean.getModule().getContext().unbind(this.getModuleJNDIName(view.getBusinessInterface()));
        if (this.hasSingleView()) {
            this.bean.getModule().getContext().unbind(this.getModuleJNDIName(null));
        }
    }

    protected boolean hasSingleView() {
        return this.views != null && this.views.size() == 1;
    }
}

