/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.inject.naming;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.injection.inject.spi.ValueRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextValueRetriever<M>
implements ValueRetriever<M> {
    private Context context;
    private final String jndiName;

    public ContextValueRetriever(String jndiName) {
        this(null, jndiName);
    }

    public ContextValueRetriever(Context context, String jndiName) {
        this.context = context;
        this.jndiName = jndiName;
    }

    @Override
    public M getValue() {
        return this.lookup(this.jndiName);
    }

    protected M lookup(String jndiName) {
        Object dependency;
        try {
            Context context = this.getContext();
            dependency = context.lookup(jndiName);
        }
        catch (NamingException e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            throw new RuntimeException("Unable to lookup jndi value: " + jndiName + cause.getMessage(), e);
        }
        return (M)dependency;
    }

    protected Context getContext() throws NamingException {
        if (this.context == null) {
            this.context = new InitialContext();
        }
        return this.context;
    }

    public String toString() {
        return "ContextValueRetriever{context=" + this.context + ", jndiName='" + this.jndiName + '\'' + '}';
    }
}

