/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.inject.pojo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.injection.inject.pojo.AbstractAccessibleObjectBeanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInjectionPoint<T, V>
extends AbstractAccessibleObjectBeanProperty<Method, T, V> {
    public MethodInjectionPoint(Method method) {
        super(method);
        assert (method.getReturnType() == Void.TYPE);
        assert (method.getParameterTypes().length == 1);
        assert (method.getName().startsWith("set"));
    }

    @Override
    public void set(T target, V value) {
        Method method = (Method)this.getAccessibleObject();
        Object[] args = new Object[]{value};
        try {
            method.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            String msg = "failed to set value " + value + " with setter " + method;
            throw new IllegalArgumentException(msg);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

