/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.measurement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.pc.measurement.MeasurementCollectorRunner;
import org.rhq.core.pc.measurement.MeasurementManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurementSenderRunner
implements Callable<MeasurementReport>,
Runnable {
    private static final Log LOG = LogFactory.getLog(MeasurementCollectorRunner.class);
    private MeasurementManager measurementManager;

    public MeasurementSenderRunner(MeasurementManager measurementManager) {
        this.measurementManager = measurementManager;
    }

    @Override
    public MeasurementReport call() throws Exception {
        MeasurementReport report = this.measurementManager.swapReport();
        if (report == null) {
            LOG.error((Object)"Measurement report is null - nothing to do.");
            return null;
        }
        this.filterUnchangedTraits(report);
        this.cleanseInvalidNumericValues(report);
        this.measurementManager.perMinuteItizeData(report);
        if (report.getDataCount() > 0L) {
            LOG.info((Object)("Measurement collection for [" + report.getDataCount() + "] metrics took " + report.getCollectionTime() + "ms - sending report to Server..."));
            this.measurementManager.sendMeasurementReport(report);
        } else {
            LOG.debug((Object)"Measurement report contains no data - not sending to Server.");
        }
        return report;
    }

    private void filterUnchangedTraits(MeasurementReport report) {
        ArrayList<MeasurementDataTrait> duplicates = new ArrayList<MeasurementDataTrait>(report.getTraitData().size());
        for (MeasurementDataTrait trait : report.getTraitData()) {
            if (this.measurementManager.checkTrait(trait.getScheduleId(), trait.getValue())) continue;
            duplicates.add(trait);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Trait " + trait.getName() + " with id " + trait.getScheduleId() + " is a dup"));
        }
        report.getTraitData().removeAll(duplicates);
    }

    private void cleanseInvalidNumericValues(MeasurementReport report) {
        Iterator iter = report.getNumericData().iterator();
        while (iter.hasNext()) {
            MeasurementDataNumeric numeric = (MeasurementDataNumeric)iter.next();
            Double v = numeric.getValue();
            if (v != null && !v.isInfinite() && !v.isNaN()) continue;
            LOG.warn((Object)("Numeric " + numeric.getName() + " with id " + numeric.getScheduleId() + " is invalid, value was '" + v + "'"));
            iter.remove();
        }
    }

    @Override
    public void run() {
        try {
            this.call();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not send measurement report", (Throwable)e);
        }
    }
}

