/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.invoker;

import org.jboss.invocation.MarshalledInvocation;
import org.jboss.jmx.connector.invoker.SerializablePolicy;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.server.Invocation;

public class SerializableInterceptor
extends AbstractInterceptor {
    private SerializablePolicy policy = new NoopPolicy();

    public void setPolicyClass(String policyClass) throws Exception {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(policyClass);
            this.policy = (SerializablePolicy)clazz.newInstance();
        }
        catch (Exception e) {
            try {
                policyClass = "org.jboss.jmx.connector.invoker.serializablepolicy." + policyClass;
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(policyClass);
                this.policy = (SerializablePolicy)clazz.newInstance();
            }
            catch (Exception inner) {
                throw e;
            }
        }
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object[] args;
        Object result = invocation.nextInterceptor().invoke(invocation);
        if ("invoke".equals(invocation.getName()) && (args = invocation.getArgs()).length == 1 && args[0] instanceof MarshalledInvocation) {
            MarshalledInvocation mi = (MarshalledInvocation)args[0];
            result = this.policy.filter(mi, result);
        }
        return result;
    }

    public class NoopPolicy
    implements SerializablePolicy {
        public Object filter(MarshalledInvocation input, Object result) throws Throwable {
            return result;
        }
    }
}

