/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import java.beans.BeanDescriptor;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.view.Location;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.TagHandlerUtils;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentBeanInfo;
import org.apache.myfaces.view.facelets.tag.composite.InterfaceDescriptorCreator;

public class InterfaceHandler
extends TagHandler
implements InterfaceDescriptorCreator {
    private static final Logger log = Logger.getLogger(InterfaceHandler.class.getName());
    public static final String NAME = "interface";
    private final TagAttribute _name = this.getAttribute("name");
    private final TagAttribute _componentType = this.getAttribute("componentType");
    private final TagAttribute _displayName = this.getAttribute("displayName");
    private final TagAttribute _preferred = this.getAttribute("preferred");
    private final TagAttribute _expert = this.getAttribute("expert");
    private final TagAttribute _shortDescription = this.getAttribute("shortDescription");
    protected final TagAttribute _hidden = this.getAttribute("hidden");
    private boolean _cacheable;
    private Collection<InterfaceDescriptorCreator> attrHandlerList;

    public InterfaceHandler(TagConfig config) {
        super(config);
        if (!(this._name != null && !this._name.isLiteral() || this._componentType != null && !this._componentType.isLiteral() || this._displayName != null && !this._displayName.isLiteral() || this._preferred != null && !this._preferred.isLiteral() || this._expert != null && !this._expert.isLiteral() || this._shortDescription != null && !this._shortDescription.isLiteral() || this._hidden != null && !this._hidden.isLiteral())) {
            this._cacheable = true;
            this.attrHandlerList = TagHandlerUtils.findNextByType(this.nextHandler, InterfaceDescriptorCreator.class);
            for (InterfaceDescriptorCreator handler : this.attrHandlerList) {
                if (handler.isCacheable()) continue;
                this._cacheable = false;
                break;
            }
            if (!this._cacheable) {
                for (InterfaceDescriptorCreator handler : this.attrHandlerList) {
                    handler.setCacheable(false);
                }
            }
        } else {
            this._cacheable = false;
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (((AbstractFaceletContext)ctx).isBuildingCompositeComponentMetadata()) {
            UIComponent compositeBaseParent = FaceletCompositionContext.getCurrentInstance(ctx).getCompositeComponentFromStack();
            CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)compositeBaseParent.getAttributes().get("javax.faces.component.BEANINFO_KEY");
            if (beanInfo == null) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.severe("Cannot find composite bean descriptor UIComponent.BEANINFO_KEY ");
                }
                return;
            }
            BeanDescriptor descriptor = beanInfo.getBeanDescriptor();
            if (this._name != null) {
                descriptor.setName(this._name.getValue(ctx));
            }
            if (this._componentType != null) {
                descriptor.setValue("javax.faces.component.COMPOSITE_COMPONENT_TYPE", this._componentType.getValueExpression(ctx, String.class));
            }
            if (this._displayName != null) {
                descriptor.setDisplayName(this._displayName.getValue(ctx));
            }
            if (this._preferred != null) {
                descriptor.setPreferred(this._preferred.getBoolean(ctx));
            }
            if (this._expert != null) {
                descriptor.setExpert(this._expert.getBoolean(ctx));
            }
            if (this._shortDescription != null) {
                descriptor.setShortDescription(this._shortDescription.getValue(ctx));
            }
            if (this._hidden != null) {
                descriptor.setHidden(this._hidden.getBoolean(ctx));
            }
            this.nextHandler.apply(ctx, parent);
        }
    }

    public boolean isCacheable() {
        return this._cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this._cacheable = cacheable;
        for (InterfaceDescriptorCreator handler : this.attrHandlerList) {
            handler.setCacheable(cacheable);
        }
    }

    public Location getLocation() {
        return this.tag.getLocation();
    }
}

