/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import java.util.List;
import java.util.SortedMap;
import java.util.TreeSet;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.ConstPool;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxws.AbstractWrapperGenerator;
import org.jboss.ws.core.utils.JavassistUtils;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.TypeMappingMetaData;
import org.jboss.ws.metadata.umdm.TypesMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;
import org.jboss.wsf.common.JavaUtils;

public class DynamicWrapperGenerator
extends AbstractWrapperGenerator {
    private static Logger log = Logger.getLogger(DynamicWrapperGenerator.class);
    protected ClassPool pool;
    protected boolean prune = true;

    public DynamicWrapperGenerator(ClassLoader loader) {
        super(loader);
        this.init(loader);
    }

    private void init(ClassLoader loader) {
        this.pool = new ClassPool(true);
        this.pool.appendClassPath((ClassPath)new LoaderClassPath(loader));
    }

    @Override
    public void reset(ClassLoader loader) {
        super.reset(loader);
        this.init(loader);
    }

    @Override
    public void generate(ParameterMetaData pmd) {
        String wrapperName = pmd.getJavaTypeName();
        List<WrappedParameter> wrappedParameters = pmd.getWrappedParameters();
        OperationMetaData opMetaData = pmd.getOperationMetaData();
        if (!opMetaData.isDocumentWrapped()) {
            throw new WSException("Operation is not document/literal (wrapped)");
        }
        if (wrappedParameters == null) {
            throw new WSException("Cannot generate a type when their is no wrapper parameters");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating wrapper: " + wrapperName));
        }
        QName xmlName = pmd.getXmlName();
        QName xmlType = pmd.getXmlType();
        try {
            CtClass clazz = this.pool.makeClass(wrapperName);
            clazz.getClassFile().setVersionToJava5();
            DynamicWrapperGenerator.addClassAnnotations(clazz, xmlName, xmlType, null);
            for (WrappedParameter parameter : wrappedParameters) {
                this.addProperty(clazz, parameter.getType(), parameter.getName(), parameter.getVariable(), parameter.getTypeArguments(), new boolean[]{parameter.isSwaRef(), parameter.isXop()}, false, parameter.isXmlList(), parameter.getAdapter());
            }
            clazz.stopPruning(!this.prune);
            this.pool.toClass(clazz, this.loader);
            JavaUtils.clearBlacklists((ClassLoader)this.loader);
        }
        catch (Exception e) {
            throw new WSException("Could not generate wrapper type: " + wrapperName, e);
        }
        TypesMetaData types = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
        types.addTypeMapping(new TypeMappingMetaData(types, xmlType, wrapperName));
    }

    @Override
    public void generate(FaultMetaData fmd) {
        String faultBeanName = fmd.getFaultBeanName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating fault bean: " + faultBeanName));
        }
        QName xmlType = fmd.getXmlType();
        Class exception = fmd.getJavaType();
        try {
            SortedMap<String, AbstractWrapperGenerator.ExceptionProperty> properties = this.getExceptionProperties(exception);
            CtClass clazz = this.pool.makeClass(faultBeanName);
            clazz.getClassFile().setVersionToJava5();
            DynamicWrapperGenerator.addClassAnnotations(clazz, fmd.getXmlName(), fmd.getXmlType(), this.getPropertyOrder(properties));
            for (AbstractWrapperGenerator.ExceptionProperty prop : properties.values()) {
                this.addProperty(clazz, prop.getReturnType().getName(), new QName(prop.getName()), prop.getName(), null, new boolean[]{false, false}, prop.isTransientAnnotated(), false, null);
            }
            clazz.stopPruning(!this.prune);
            this.pool.toClass(clazz, this.loader);
            JavaUtils.clearBlacklists((ClassLoader)this.loader);
        }
        catch (Exception e) {
            throw new WSException("Could not generate fault wrapper bean: " + faultBeanName, e);
        }
        TypesMetaData types = fmd.getOperationMetaData().getEndpointMetaData().getServiceMetaData().getTypesMetaData();
        types.addTypeMapping(new TypeMappingMetaData(types, xmlType, faultBeanName));
    }

    private static String getterPrefix(CtClass type) {
        return type == CtClass.booleanType || "java.lang.Boolean".equals(type.getName()) ? "is" : "get";
    }

    private String[] getPropertyOrder(SortedMap<String, AbstractWrapperGenerator.ExceptionProperty> sortedProperties) {
        TreeSet<String> set = new TreeSet<String>();
        for (String prop : sortedProperties.keySet()) {
            if (((AbstractWrapperGenerator.ExceptionProperty)sortedProperties.get(prop)).isTransientAnnotated()) continue;
            set.add(prop);
        }
        return set.toArray(new String[0]);
    }

    private String typeSignature(String type, String[] arguments) {
        StringBuilder ret = new StringBuilder(JavaUtils.toSignature((String)type));
        ret.deleteCharAt(ret.length() - 1).append('<');
        for (String arg : arguments) {
            ret.append(JavaUtils.toSignature((String)arg));
        }
        return ret.append(">;").toString();
    }

    private String getterSignature(String type) {
        return "()" + type;
    }

    private String setterSignature(String type) {
        return "(" + type + ")V";
    }

    private void addProperty(CtClass clazz, String typeName, QName name, String variable, String[] typeArguments, boolean[] attachments, boolean xmlTransient, boolean xmlList, String adapter) throws CannotCompileException, NotFoundException {
        JavassistUtils.Annotation annotation;
        ConstPool constPool = clazz.getClassFile().getConstPool();
        String fieldName = JavaUtils.isReservedKeyword((String)variable) ? "_" + variable : variable;
        CtField field = new CtField(this.pool.get(typeName), fieldName, clazz);
        field.setModifiers(2);
        String typeSignature = null;
        if (typeArguments != null) {
            typeSignature = this.typeSignature(typeName, typeArguments);
            JavassistUtils.addSignature(field, typeSignature);
        }
        if (!xmlTransient) {
            annotation = JavassistUtils.createAnnotation(XmlElement.class, constPool);
            if (name.getNamespaceURI() != null) {
                annotation.addParameter("namespace", name.getNamespaceURI());
            }
            annotation.addParameter("name", name.getLocalPart());
            annotation.markField(field);
        }
        if (attachments[0]) {
            annotation = JavassistUtils.createAnnotation(XmlAttachmentRef.class, constPool);
            annotation.markField(field);
        }
        if (attachments[1]) {
            annotation = JavassistUtils.createAnnotation(XmlMimeType.class, constPool);
            annotation.addParameter("value", "application/octet-stream");
            annotation.markField(field);
        }
        if (xmlTransient) {
            annotation = JavassistUtils.createAnnotation(XmlTransient.class, constPool);
            annotation.markField(field);
        }
        if (xmlList) {
            annotation = JavassistUtils.createAnnotation(XmlList.class, constPool);
            annotation.markField(field);
        }
        if (adapter != null) {
            annotation = JavassistUtils.createAnnotation(XmlJavaTypeAdapter.class, constPool);
            annotation.addClassParameter("value", adapter);
            annotation.markField(field);
        }
        clazz.addField(field);
        CtMethod getter = CtNewMethod.getter((String)(DynamicWrapperGenerator.getterPrefix(field.getType()) + JavaUtils.capitalize((String)variable)), (CtField)field);
        CtMethod setter = CtNewMethod.setter((String)("set" + JavaUtils.capitalize((String)variable)), (CtField)field);
        if (typeSignature != null) {
            JavassistUtils.addSignature(getter, this.getterSignature(typeSignature));
            JavassistUtils.addSignature(setter, this.setterSignature(typeSignature));
        }
        clazz.addMethod(getter);
        clazz.addMethod(setter);
    }

    private static void addClassAnnotations(CtClass clazz, QName xmlName, QName xmlType, String[] propertyOrder) {
        ConstPool constPool = clazz.getClassFile().getConstPool();
        JavassistUtils.Annotation annotation = JavassistUtils.createAnnotation(XmlRootElement.class, constPool);
        if (xmlName.getNamespaceURI() != null && xmlName.getNamespaceURI().length() > 0) {
            annotation.addParameter("namespace", xmlName.getNamespaceURI());
        }
        annotation.addParameter("name", xmlName.getLocalPart());
        annotation.markClass(clazz);
        annotation = JavassistUtils.createAnnotation(XmlType.class, constPool);
        if (xmlType.getNamespaceURI() != null && xmlType.getNamespaceURI().length() > 0) {
            annotation.addParameter("namespace", xmlType.getNamespaceURI());
        }
        annotation.addParameter("name", xmlType.getLocalPart());
        if (propertyOrder != null) {
            annotation.addParameter("propOrder", propertyOrder);
        }
        annotation.markClass(clazz);
        annotation = JavassistUtils.createAnnotation(XmlAccessorType.class, constPool);
        annotation.addParameter("value", (Enum)XmlAccessType.FIELD);
        annotation.markClass(clazz);
    }
}

