/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.binding;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.soap.MimeHeaders;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.HTTPMessageImpl;
import org.jboss.ws.core.client.UnMarshaller;

public class HTTPMessageUnMarshaller
implements UnMarshaller {
    private static Logger log = Logger.getLogger(HTTPMessageUnMarshaller.class);
    private static List<Integer> validResponseCodes = new ArrayList<Integer>();

    @Override
    public Object read(InputStream inputStream, Map<String, Object> metadata, Map<String, Object> headers) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Read input stream with metadata=" + metadata));
        }
        Integer resCode = (Integer)metadata.get("org.jboss.ws.core.client.transport.NettyClient#ResponseCode");
        String resMessage = (String)metadata.get("org.jboss.ws.core.client.transport.NettyClient#ResponseCodeMessage");
        if (resCode != null && !validResponseCodes.contains(resCode)) {
            throw new WSException("Invalid HTTP server response [" + resCode + "] - " + resMessage);
        }
        MimeHeaders mimeHeaders = this.getMimeHeaders(headers);
        HTTPMessageImpl soapMsg = new HTTPMessageImpl(mimeHeaders, inputStream);
        return soapMsg;
    }

    private MimeHeaders getMimeHeaders(Map<String, Object> metadata) {
        MimeHeaders headers = new MimeHeaders();
        for (String key : metadata.keySet()) {
            Object value = metadata.get(key);
            if (key == null || !(value instanceof List)) continue;
            for (Object listValue : (List)value) {
                headers.addHeader(key, listValue.toString());
            }
        }
        return headers;
    }

    static {
        validResponseCodes.add(200);
        validResponseCodes.add(202);
        validResponseCodes.add(500);
    }
}

