/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.impl.factory.session.stateless;

import java.io.Serializable;
import java.util.Set;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.proxy.impl.factory.session.SessionSpecProxyFactory;
import org.jboss.ejb3.proxy.impl.factory.session.stateless.StatelessSessionProxyFactoryBase;
import org.jboss.ejb3.proxy.impl.handler.session.SessionProxyInvocationHandler;
import org.jboss.ejb3.proxy.impl.handler.session.SessionRemoteProxyInvocationHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessSessionRemoteProxyFactory
extends StatelessSessionProxyFactoryBase
implements SessionSpecProxyFactory {
    private static final Logger logger = Logger.getLogger(StatelessSessionRemoteProxyFactory.class);
    private static final String DEFAULT_STACK_NAME_STATELESS_SESSION_CLIENT_INTERCEPTORS = "StatelessSessionClientInterceptors";
    private String url;

    public StatelessSessionRemoteProxyFactory(String name, String containerName, String containerGuid, JBossSessionBeanMetaData metadata, ClassLoader classloader, String url, Advisor advisor, String overrideInterceptorStackName) {
        super(name, containerName, containerGuid, metadata, classloader, advisor, overrideInterceptorStackName);
        this.setUrl(url);
    }

    @Override
    protected final Set<String> getBusinessInterfaceTypes() {
        return this.getMetadata().getBusinessRemotes();
    }

    @Override
    protected final String getHomeType() {
        return this.getMetadata().getHome();
    }

    @Override
    protected final String getEjb2xInterfaceType() {
        return this.getMetadata().getRemote();
    }

    @Override
    protected SessionProxyInvocationHandler createBusinessInterfaceSpecificInvocationHandler(Serializable target, String businessInterfaceName) {
        String containerName = this.getContainerName();
        String containerGuid = this.getContainerGuid();
        String url = this.getUrl();
        Interceptor[] interceptors = this.getInterceptors();
        SessionRemoteProxyInvocationHandler handler = new SessionRemoteProxyInvocationHandler(containerName, containerGuid, interceptors, businessInterfaceName, target, url);
        return handler;
    }

    @Override
    protected SessionProxyInvocationHandler createBusinessDefaultInvocationHandler(Serializable target) {
        return this.createBusinessInterfaceSpecificInvocationHandler(target, null);
    }

    @Override
    protected SessionProxyInvocationHandler createEjb2xComponentInterfaceInvocationHandler(Serializable target) {
        return this.createBusinessDefaultInvocationHandler(target);
    }

    @Override
    protected SessionProxyInvocationHandler createHomeInvocationHandler() {
        return this.createBusinessDefaultInvocationHandler(null);
    }

    @Override
    protected String getDefaultInterceptorStackName() {
        return DEFAULT_STACK_NAME_STATELESS_SESSION_CLIENT_INTERCEPTORS;
    }

    @Override
    public Object createProxyBusiness(String businessInterfaceName) {
        return this.createProxyBusiness(null, businessInterfaceName);
    }

    @Override
    public Object createProxyEjb2x() {
        return this.createProxyEjb2x(null);
    }

    @Override
    public Object createProxyDefault() {
        return super.createProxyDefault(null);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

