/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.base;

import java.net.URL;
import java.util.Set;
import org.jboss.classloader.spi.ClassLoaderCache;
import org.jboss.classloader.spi.ImportType;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.base.ClassLoaderInformation;

class ClassLoaderCacheWrapper
implements ClassLoaderCache {
    private ClassLoaderCache delegate;
    private ClassLoaderInformation info;

    ClassLoaderCacheWrapper(ClassLoaderCache delegate, ClassLoaderInformation info) {
        this.delegate = delegate;
        this.info = info;
    }

    protected boolean isImported(String name) {
        Set<String> imports;
        if (this.info != null && !(imports = this.info.getImportedPackages()).isEmpty()) {
            String pckg = ClassLoaderInformation.getResourcePackageName(name);
            return imports.contains(pckg);
        }
        return false;
    }

    public Loader getCachedLoader(String name) {
        Loader loader = this.delegate.getCachedLoader(name);
        if (loader != null && !this.isImported(name)) {
            loader = null;
        }
        return loader;
    }

    public Loader findLoader(ImportType type, String name) {
        Loader loader = this.delegate.findLoader(type, name);
        if (loader != null) {
            this.cacheLoader(name, loader);
            return loader;
        }
        if (this.info != null && (loader = this.info.findLoader(type, name)) != null) {
            this.cacheLoader(name, loader);
        }
        return loader;
    }

    public void cacheLoader(String name, Loader loader) {
        this.delegate.cacheLoader(name, loader);
    }

    public boolean isBlackListedClass(String name) {
        return this.delegate.isBlackListedClass(name) && this.isImported(name);
    }

    public void blackListClass(String name) {
        if (this.isImported(name)) {
            this.delegate.blackListClass(name);
        }
    }

    public URL getCachedResource(String name) {
        URL url = this.delegate.getCachedResource(name);
        if (url != null && !this.isImported(name)) {
            url = null;
        }
        return url;
    }

    public URL findResource(ImportType type, String name) {
        URL url = this.delegate.findResource(type, name);
        if (url != null) {
            this.cacheResource(name, url);
            return url;
        }
        if (this.info != null && (url = this.info.findResource(type, name)) != null) {
            this.cacheResource(name, url);
        }
        return url;
    }

    public void cacheResource(String name, URL resource) {
        this.delegate.cacheResource(name, resource);
    }

    public boolean isBlackListedResource(String name) {
        return this.delegate.isBlackListedResource(name) && this.isImported(name);
    }

    public void blackListResource(String name) {
        if (this.isImported(name)) {
            this.delegate.blackListResource(name);
        }
    }

    public void flushCaches() {
        this.delegate.flushCaches();
    }

    public void clearBlackList(String name) {
        this.delegate.clearBlackList(name);
    }

    public boolean isRelevant(ImportType type) {
        return this.delegate.isRelevant(type);
    }

    public String getInfo(ImportType type) {
        return this.delegate.getInfo(type);
    }
}

