/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.ejbref.resolver.ejb30.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.ejbref.resolver.ejb30.impl.EJB30MetaDataBasedEjbReferenceResolver;
import org.jboss.ejb3.ejbref.resolver.ejb30.impl.MetaDataBasedEjbReferenceResolver;
import org.jboss.ejb3.ejbref.resolver.spi.EjbReference;
import org.jboss.ejb3.ejbref.resolver.spi.EjbReferenceResolver;
import org.jboss.ejb3.ejbref.resolver.spi.UnresolvableReferenceException;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

public class ScopedEJBReferenceResolver
implements EjbReferenceResolver {
    private static Logger logger = Logger.getLogger(ScopedEJBReferenceResolver.class);
    protected MetaDataBasedEjbReferenceResolver metadataBasedEjbReferenceResolver = new EJB30MetaDataBasedEjbReferenceResolver();

    protected String find(DeploymentUnit du, EjbReference reference) {
        JBossMetaData metadata = this.getMetaData(du);
        if (metadata == null) {
            return null;
        }
        return this.getMetaDataBasedEjbReferenceResolver().resolveEjb(reference, metadata, du.getClassLoader());
    }

    public String resolveEjb(DeploymentUnit du, EjbReference reference) throws UnresolvableReferenceException {
        if (reference.getMappedName() != null && !reference.getMappedName().isEmpty()) {
            logger.debug((Object)("Bypassing resolution, using mappedName of " + reference));
            return reference.getMappedName();
        }
        String jndiName = this.resolveWithinDeploymentUnit(du, new HashSet<DeploymentUnit>(), reference);
        if (jndiName == null) {
            throw new UnresolvableReferenceException("Could not resolve reference " + reference + " in " + du);
        }
        return jndiName;
    }

    protected String resolveWithinDeploymentUnit(DeploymentUnit du, Collection<DeploymentUnit> alreadyScannedDUs, EjbReference reference) {
        List children;
        String jndiName = this.find(du, reference);
        if (jndiName != null) {
            return jndiName;
        }
        if (alreadyScannedDUs == null) {
            alreadyScannedDUs = new HashSet<DeploymentUnit>();
        }
        if ((children = du.getChildren()) != null) {
            for (DeploymentUnit child : children) {
                if (alreadyScannedDUs.contains(child)) continue;
                jndiName = this.resolveWithinDeploymentUnit(child, alreadyScannedDUs, reference);
                if (jndiName != null) {
                    return jndiName;
                }
                alreadyScannedDUs.add(child);
            }
        }
        alreadyScannedDUs.add(du);
        DeploymentUnit parent = du.getParent();
        if (parent != null) {
            return this.resolveWithinDeploymentUnit(parent, alreadyScannedDUs, reference);
        }
        return null;
    }

    protected JBossMetaData getMetaData(DeploymentUnit du) {
        return (JBossMetaData)du.getAttachment(EJB30MetaDataBasedEjbReferenceResolver.DU_ATTACHMENT_NAME_METADATA, JBossMetaData.class);
    }

    protected MetaDataBasedEjbReferenceResolver getMetaDataBasedEjbReferenceResolver() {
        return this.metadataBasedEjbReferenceResolver;
    }
}

