/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.deployer.kernel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.deployer.kernel.KernelControllerContextComparator;
import org.jboss.deployers.vfs.spi.deployer.helpers.BeanMetaDataDeployerPlugin;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetaDataDeployer
extends AbstractSimpleRealDeployer<BeanMetaData> {
    private Controller controller;
    private List<BeanMetaDataDeployerPlugin> plugins = new ArrayList<BeanMetaDataDeployerPlugin>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<String, BeanMetaDataDeployerPlugin> deployedWithPlugin = new ConcurrentHashMap<String, BeanMetaDataDeployerPlugin>();

    public BeanMetaDataDeployer(Kernel kernel) {
        super(BeanMetaData.class);
        if (kernel == null) {
            throw new IllegalArgumentException("Null kernel");
        }
        this.init((Controller)kernel.getController());
    }

    public BeanMetaDataDeployer(Controller controller) {
        super(BeanMetaData.class);
        this.init(controller);
    }

    protected void init(Controller controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        this.controller = controller;
        this.setComponentsOnly(true);
        this.setUseUnitName(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addControllerContextCreator(BeanMetaDataDeployerPlugin creator) {
        if (creator == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.plugins.add(creator);
            Collections.sort(this.plugins, KernelControllerContextComparator.getInstance());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeControllerContextCreator(BeanMetaDataDeployerPlugin creator) {
        if (creator == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.plugins.remove(creator);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void deploy(DeploymentUnit unit, BeanMetaData deployment) throws DeploymentException {
        if (deployment.getClassLoader() == null) {
            try {
                unit.getClassLoader();
                deployment.setClassLoader((ClassLoaderMetaData)new DeploymentClassLoaderMetaData(unit));
            }
            catch (Exception e) {
                this.log.debugf("Unable to retrieve classloader for deployment: %1s reason=%2s", (Object)unit.getName(), (Object)e);
            }
        }
        KernelControllerContext context = this.createControllerContext(unit, deployment);
        ScopeInfo scopeInfo = context.getScopeInfo();
        scopeInfo.setScope(unit.getScope());
        scopeInfo.setMutableScope(unit.getMutableScope());
        try {
            this.putContext((ControllerContext)context, unit.getParent());
            this.controller.install((ControllerContext)context);
        }
        catch (Throwable t) {
            this.removeContext((ControllerContext)context, unit.getParent());
            throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + deployment.getName()), (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KernelControllerContext createControllerContext(DeploymentUnit unit, BeanMetaData deployment) {
        if (this.plugins.size() > 0) {
            this.lock.readLock().lock();
            try {
                for (BeanMetaDataDeployerPlugin plugin : this.plugins) {
                    KernelControllerContext context = plugin.createContext(this.controller, unit, deployment);
                    if (context == null) continue;
                    this.deployedWithPlugin.put(deployment.getName(), plugin);
                    KernelControllerContext kernelControllerContext = context;
                    return kernelControllerContext;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return new AbstractKernelControllerContext(null, deployment, null);
    }

    public void undeploy(DeploymentUnit unit, BeanMetaData deployment) {
        ClassLoaderMetaData classLoader;
        BeanMetaDataDeployerPlugin plugin = this.deployedWithPlugin.remove(deployment.getName());
        if (plugin == null || !plugin.uninstallContext(this.controller, unit, deployment)) {
            ControllerContext context = this.controller.uninstall((Object)deployment.getName());
            this.removeContext(context, unit.getParent());
        }
        if ((classLoader = deployment.getClassLoader()) instanceof DeploymentClassLoaderMetaData) {
            deployment.setClassLoader(null);
        }
    }

    private class DeploymentClassLoaderMetaData
    extends AbstractClassLoaderMetaData {
        private static final long serialVersionUID = 1L;
        private DeploymentUnit unit;

        public DeploymentClassLoaderMetaData(DeploymentUnit unit) {
            if (unit == null) {
                throw new IllegalArgumentException("Null unit");
            }
            this.unit = unit;
        }

        public ValueMetaData getClassLoader() {
            return new AbstractValueMetaData((Object)this.unit.getClassLoader());
        }
    }
}

