/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.ChannelImpl;
import org.hornetq.core.protocol.core.impl.PacketDecoder;
import org.hornetq.core.protocol.core.impl.wireformat.DisconnectMessage;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.utils.SimpleIDGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotingConnectionImpl
implements BufferHandler,
CoreRemotingConnection {
    private static final Logger log = Logger.getLogger(RemotingConnectionImpl.class);
    private final Connection transportConnection;
    private final Map<Long, Channel> channels = new ConcurrentHashMap<Long, Channel>();
    private final List<FailureListener> failureListeners = new CopyOnWriteArrayList<FailureListener>();
    private final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();
    private final long blockingCallTimeout;
    private final List<Interceptor> interceptors;
    private volatile boolean destroyed;
    private final boolean client;
    private volatile SimpleIDGenerator idGenerator = new SimpleIDGenerator(10L);
    private boolean idGeneratorSynced = false;
    private final Object transferLock = new Object();
    private final Object failLock = new Object();
    private final PacketDecoder decoder = new PacketDecoder();
    private volatile boolean dataReceived;
    private final Executor executor;
    private volatile boolean executing;
    private final SimpleString nodeID;
    private final long creationTime;
    private String clientID;

    public RemotingConnectionImpl(Connection transportConnection, long blockingCallTimeout, List<Interceptor> interceptors) {
        this(transportConnection, blockingCallTimeout, interceptors, true, null, null);
    }

    public RemotingConnectionImpl(Connection transportConnection, List<Interceptor> interceptors, Executor executor, SimpleString nodeID) {
        this(transportConnection, -1L, interceptors, false, executor, nodeID);
    }

    private RemotingConnectionImpl(Connection transportConnection, long blockingCallTimeout, List<Interceptor> interceptors, boolean client, Executor executor, SimpleString nodeID) {
        this.transportConnection = transportConnection;
        this.blockingCallTimeout = blockingCallTimeout;
        this.interceptors = interceptors;
        this.client = client;
        this.executor = executor;
        this.nodeID = nodeID;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public Connection getTransportConnection() {
        return this.transportConnection;
    }

    @Override
    public List<FailureListener> getFailureListeners() {
        return new ArrayList<FailureListener>(this.failureListeners);
    }

    @Override
    public void setFailureListeners(List<FailureListener> listeners) {
        this.failureListeners.clear();
        this.failureListeners.addAll(listeners);
    }

    @Override
    public Object getID() {
        return this.transportConnection.getID();
    }

    @Override
    public String getRemoteAddress() {
        return this.transportConnection.getRemoteAddress();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public synchronized Channel getChannel(long channelID, int confWindowSize) {
        Channel channel = this.channels.get(channelID);
        if (channel == null) {
            channel = new ChannelImpl(this, channelID, confWindowSize);
            this.channels.put(channelID, channel);
        }
        return channel;
    }

    @Override
    public synchronized boolean removeChannel(long channelID) {
        return this.channels.remove(channelID) != null;
    }

    @Override
    public synchronized void putChannel(long channelID, Channel channel) {
        this.channels.put(channelID, channel);
    }

    @Override
    public void addFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        this.failureListeners.add(listener);
    }

    @Override
    public boolean removeFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        return this.failureListeners.remove(listener);
    }

    @Override
    public void addCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        this.closeListeners.add(listener);
    }

    @Override
    public boolean removeCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        return this.closeListeners.remove(listener);
    }

    @Override
    public List<CloseListener> removeCloseListeners() {
        ArrayList<CloseListener> ret = new ArrayList<CloseListener>(this.closeListeners);
        this.closeListeners.clear();
        return ret;
    }

    @Override
    public List<FailureListener> removeFailureListeners() {
        ArrayList<FailureListener> ret = new ArrayList<FailureListener>(this.failureListeners);
        this.failureListeners.clear();
        return ret;
    }

    @Override
    public void setCloseListeners(List<CloseListener> listeners) {
        this.closeListeners.clear();
        this.closeListeners.addAll(listeners);
    }

    @Override
    public HornetQBuffer createBuffer(int size) {
        return this.transportConnection.createBuffer(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail(HornetQException me) {
        Object object = this.failLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        log.warn("Connection failure has been detected: " + me.getMessage() + " [code=" + me.getCode() + "]");
        this.callFailureListeners(me);
        this.callClosingListeners();
        this.internalClose();
        for (Channel channel : this.channels.values()) {
            channel.returnBlocking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.failLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        this.internalClose();
        this.callClosingListeners();
    }

    @Override
    public void disconnect() {
        Channel channel0 = this.getChannel(0L, -1);
        HashSet<Channel> allChannels = new HashSet<Channel>(this.channels.values());
        this.removeAllChannels();
        for (Channel channel : allChannels) {
            channel.flushConfirmations();
        }
        DisconnectMessage disconnect = new DisconnectMessage(this.nodeID);
        channel0.sendAndFlush(disconnect);
    }

    @Override
    public long generateChannelID() {
        return this.idGenerator.generateID();
    }

    @Override
    public synchronized void syncIDGeneratorSequence(long id) {
        if (!this.idGeneratorSynced) {
            this.idGenerator = new SimpleIDGenerator(id);
            this.idGeneratorSynced = true;
        }
    }

    @Override
    public long getIDGeneratorSequence() {
        return this.idGenerator.getCurrentID();
    }

    @Override
    public Object getTransferLock() {
        return this.transferLock;
    }

    @Override
    public boolean isClient() {
        return this.client;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public long getBlockingCallTimeout() {
        return this.blockingCallTimeout;
    }

    @Override
    public boolean checkDataReceived() {
        boolean res = this.dataReceived;
        this.dataReceived = false;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.transferLock;
        synchronized (object) {
            for (Channel channel : this.channels.values()) {
                channel.flushConfirmations();
            }
        }
    }

    @Override
    public void checkFlushBatchBuffer() {
        this.transportConnection.checkFlushBatchBuffer();
    }

    @Override
    public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
        try {
            final Packet packet = this.decoder.decode(buffer);
            if (packet.isAsyncExec() && this.executor != null) {
                this.executing = true;
                this.executor.execute(new Runnable(){

                    public void run() {
                        try {
                            RemotingConnectionImpl.this.doBufferReceived(packet);
                        }
                        catch (Throwable t) {
                            log.error("Unexpected error", t);
                        }
                        RemotingConnectionImpl.this.executing = false;
                    }
                });
            } else {
                while (this.executing) {
                    Thread.yield();
                }
                this.doBufferReceived(packet);
            }
            this.dataReceived = true;
        }
        catch (Exception e) {
            log.error("Failed to decode", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBufferReceived(Packet packet) {
        if (this.interceptors != null) {
            for (Interceptor interceptor : this.interceptors) {
                try {
                    boolean callNext = interceptor.intercept(packet, this);
                    if (callNext) continue;
                    return;
                }
                catch (Throwable e) {
                    log.warn("Failure in calling interceptor: " + interceptor, e);
                }
            }
        }
        Object object = this.transferLock;
        synchronized (object) {
            Channel channel = this.channels.get(packet.getChannelID());
            if (channel != null) {
                channel.handlePacket(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllChannels() {
        Object object = this.transferLock;
        synchronized (object) {
            this.channels.clear();
        }
    }

    private void callFailureListeners(HornetQException me) {
        ArrayList<FailureListener> listenersClone = new ArrayList<FailureListener>(this.failureListeners);
        for (FailureListener listener : listenersClone) {
            try {
                listener.connectionFailed(me, false);
            }
            catch (Throwable t) {
                log.error("Failed to execute failure listener", t);
            }
        }
    }

    private void callClosingListeners() {
        ArrayList<CloseListener> listenersClone = new ArrayList<CloseListener>(this.closeListeners);
        for (CloseListener listener : listenersClone) {
            try {
                listener.connectionClosed();
            }
            catch (Throwable t) {
                log.error("Failed to execute failure listener", t);
            }
        }
    }

    private void internalClose() {
        this.transportConnection.close();
        for (Channel channel : this.channels.values()) {
            channel.close();
        }
    }

    public void setClientID(String cID) {
        this.clientID = cID;
    }

    public String getClientID() {
        return this.clientID;
    }
}

