/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class ReplicationLargeMessageWriteMessage
extends PacketImpl {
    private long messageId;
    private byte[] body;

    public ReplicationLargeMessageWriteMessage() {
        super((byte)101);
    }

    public ReplicationLargeMessageWriteMessage(long messageId, byte[] body) {
        this();
        this.messageId = messageId;
        this.body = body;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeLong(this.messageId);
        buffer.writeInt(this.body.length);
        buffer.writeBytes(this.body);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.messageId = buffer.readLong();
        int size = buffer.readInt();
        this.body = new byte[size];
        buffer.readBytes(this.body);
    }

    public long getMessageId() {
        return this.messageId;
    }

    public byte[] getBody() {
        return this.body;
    }
}

