/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.wireformat.SessionContinuationMessage;

public class SessionSendContinuationMessage
extends SessionContinuationMessage {
    private boolean requiresResponse;
    private long messageBodySize = -1L;

    public SessionSendContinuationMessage() {
        super((byte)73);
    }

    public SessionSendContinuationMessage(byte[] body, boolean continues, boolean requiresResponse) {
        super((byte)73, body, continues);
        this.requiresResponse = requiresResponse;
    }

    public SessionSendContinuationMessage(byte[] body, boolean continues, boolean requiresResponse, long messageBodySize) {
        this(body, continues, requiresResponse);
        this.messageBodySize = messageBodySize;
    }

    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    public long getMessageBodySize() {
        return this.messageBodySize;
    }

    public void encodeRest(HornetQBuffer buffer) {
        super.encodeRest(buffer);
        if (!this.continues) {
            buffer.writeLong(this.messageBodySize);
        }
        buffer.writeBoolean(this.requiresResponse);
    }

    public void decodeRest(HornetQBuffer buffer) {
        super.decodeRest(buffer);
        if (!this.continues) {
            this.messageBodySize = buffer.readLong();
        }
        this.requiresResponse = buffer.readBoolean();
    }
}

