/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.dependency;

import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.profileservice.dependency.ProfileControllerContext;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.dependency.ProfileRequirement;
import org.jboss.util.JBossStringBuilder;

public class ProfileRequirementDependencyItem
extends AbstractDependencyItem {
    private final ProfileControllerContext context;
    private final ProfileRequirement requirement;
    private volatile ProfileKey resolved;

    public ProfileRequirementDependencyItem(ProfileControllerContext context, ProfileRequirement requirement, ProfileKey key, ControllerState dependentState) {
        super((Object)(context != null ? context.getProfileKey() : null), null, ControllerState.DESCRIBED, dependentState);
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        if (requirement == null) {
            throw new IllegalArgumentException("null requirement");
        }
        this.context = context;
        this.requirement = requirement;
        this.resolved = key;
    }

    public ProfileKey getName() {
        return this.context.getProfileKey();
    }

    public ProfileRequirement getRequirement() {
        return this.requirement;
    }

    public void setIDependOn(Object iDependOn) {
        super.setIDependOn(iDependOn);
    }

    public boolean resolve(Controller controller) {
        ProfileKey iDependOn = this.resolved;
        if (iDependOn == null && (iDependOn = this.context.resolve(this.requirement)) != null) {
            this.resolved = iDependOn;
        }
        if (iDependOn == null) {
            this.setResolved(this.getRequirement().isOptional());
            return this.isResolved();
        }
        if (this.getName().equals((Object)iDependOn)) {
            this.setResolved(true);
            return this.isResolved();
        }
        this.indexStates(controller, ControllerState.DESCRIBED, ControllerState.INSTALLED);
        ControllerContext context = controller.getContext((Object)iDependOn, this.getDependentState());
        if (context != null) {
            this.addDependsOnMe(controller, context);
            this.setIDependOn(context.getName());
            this.setResolved(true);
            return this.isResolved();
        }
        context = controller.getContext((Object)iDependOn, null);
        if (context != null && ControllerMode.ON_DEMAND.equals((Object)context.getMode())) {
            block7: {
                try {
                    controller.enableOnDemand(context);
                }
                catch (Throwable ignored) {
                    if (!log.isTraceEnabled()) break block7;
                    log.trace((Object)"Unexpected error", ignored);
                }
            }
            this.setIDependOn(context.getName());
            this.setResolved(true);
            return this.isResolved();
        }
        this.setResolved(false);
        return this.isResolved();
    }

    public boolean unresolved(Controller controller) {
        this.setIDependOn(null);
        this.setResolved(false);
        return true;
    }

    public void toShortString(JBossStringBuilder buffer) {
        super.toShortString(buffer);
        buffer.append(", requirement=").append((Object)this.getRequirement());
    }

    protected void toHumanReadableString(StringBuilder builder) {
        super.toHumanReadableString(builder);
        builder.append(", requirement=").append(this.getRequirement());
    }
}

