/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.deployment;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.kernel.Kernel;
import org.jboss.profileservice.deployment.ProfileDeployerPlugin;
import org.jboss.profileservice.profile.bootstrap.BootstrapDeployerPlugin;
import org.jboss.profileservice.profile.bootstrap.BootstrapProfileMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

public class ProfileDeployerPluginRegistry {
    private Map<String, ProfileDeployerPlugin> map = new ConcurrentHashMap<String, ProfileDeployerPlugin>();
    private ProfileDeployerPlugin defaultPlugin = null;

    public ProfileDeployerPluginRegistry(Kernel kernel) {
        BootstrapDeployerPlugin kernelDeployer = new BootstrapDeployerPlugin(kernel);
        this.map.put(BootstrapProfileMetaData.class.getName(), kernelDeployer);
    }

    public ProfileDeployerPlugin getDeployer(ProfileMetaData metaData) {
        String type = metaData.getClass().getName();
        ProfileDeployerPlugin plugin = this.map.get(type);
        if (plugin == null) {
            return this.defaultPlugin;
        }
        return plugin;
    }

    public void setDefaultPlugin(ProfileDeployerPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("null deployer plugin");
        }
        this.defaultPlugin = plugin;
    }

    public void removeDefaultPlugin() {
        this.defaultPlugin = null;
    }

    public void addPlugin(String type, ProfileDeployerPlugin plugin) {
        if (type == null) {
            throw new IllegalArgumentException("null plugin type");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("null deployer plugin");
        }
        this.map.put(type, plugin);
    }

    public void removePlugin(String type) {
        if (type == null) {
            throw new IllegalArgumentException("null plugin type");
        }
        this.map.remove(type);
    }

    public void checkAllComplete() throws Exception {
        for (Map.Entry<String, ProfileDeployerPlugin> deployers : this.map.entrySet()) {
            deployers.getValue().checkComplete();
        }
        if (this.defaultPlugin != null) {
            this.defaultPlugin.checkComplete();
        }
    }

    public void prepareShutdown() {
        for (ProfileDeployerPlugin deployer : this.map.values()) {
            deployer.prepareShutdown();
        }
    }

    public void shutdown() {
        for (ProfileDeployerPlugin deployer : this.map.values()) {
            deployer.shutdown();
        }
    }
}

