/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import java.util.ArrayList;
import java.util.List;
import org.jboss.profileservice.management.TwoPCActionWrapper;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.action.EventBus;
import org.jboss.profileservice.spi.action.ModificationEvent;
import org.jboss.profileservice.spi.action.ModificationStatus;
import org.jboss.profileservice.spi.action.ProfileModificationAction;
import org.jboss.profileservice.spi.action.ProfileModificationContext;
import org.jboss.profileservice.spi.action.ProfileModificationRequest;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.action.TwoPhaseCommitProfileAction;

class ModificationSession {
    private EventBus eventBus;
    private ProfileModificationRequest request;
    private AbstractModificationResponse response = new AbstractModificationResponse();
    private List<TwoPhaseCommitProfileAction<?>> prepared = new ArrayList();

    ModificationSession(ProfileModificationRequest request, EventBus eventBus) {
        this.request = request;
        this.eventBus = eventBus;
    }

    public AbstractModificationResponse getResponse() {
        return this.response;
    }

    boolean prepare() {
        boolean success = true;
        for (ProfileKey key : this.request.getProfilesKeys()) {
            for (ProfileModificationAction action : this.request.getActions(key)) {
                if (!success) {
                    action.cancel();
                    continue;
                }
                Object tpca = null;
                tpca = action instanceof TwoPhaseCommitProfileAction ? (TwoPhaseCommitProfileAction)TwoPhaseCommitProfileAction.class.cast(action) : new TwoPCActionWrapper((ProfileModificationAction<? extends ProfileModificationContext>)action);
                success &= tpca.prepare((ProfileModificationResponse)this.response);
                this.prepared.add((TwoPhaseCommitProfileAction<?>)tpca);
            }
        }
        return success;
    }

    public void commit() {
        for (TwoPhaseCommitProfileAction<?> tpca : this.prepared) {
            tpca.commit((ProfileModificationResponse)this.response);
        }
        this.response.markAsCompleted();
    }

    public void rollback() {
        for (TwoPhaseCommitProfileAction<?> tpca : this.prepared) {
            tpca.rollback((ProfileModificationResponse)this.response);
        }
        this.response.markAsFailed();
        this.response.markAsCompleted();
    }

    public class AbstractModificationResponse
    implements ProfileModificationResponse,
    ModificationStatus {
        private Object response;
        private Throwable failure;
        private boolean failed;
        private boolean completed;

        public void setFailure(Throwable t) {
            this.failure = t;
            this.markAsFailed();
        }

        public void fireModificationEvent(ModificationEvent event) {
            ModificationSession.this.eventBus.fireModificationEvent(event);
        }

        public Object getResponse() {
            return this.response;
        }

        public ModificationStatus getStatus() {
            return this;
        }

        public void setResponse(Object response) {
            this.response = response;
        }

        public Throwable getFailure() {
            return this.failure;
        }

        public boolean isFailed() {
            return this.failed;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        void markAsCompleted() {
            this.completed = true;
        }

        void markAsFailed() {
            this.failed = true;
        }
    }
}

