/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.profile.metadata;

import javax.xml.bind.annotation.XmlAttribute;
import org.jboss.profileservice.profile.metadata.FeatureRequirement;
import org.jboss.profileservice.spi.dependency.ProfileCapability;
import org.jboss.profileservice.spi.dependency.ProfileRequirement;
import org.jboss.profileservice.spi.metadata.ProfileMetaDataVisitor;
import org.jboss.profileservice.spi.metadata.ProfileMetaDataVisitorNode;

public class FeatureCapability
implements ProfileCapability,
ProfileMetaDataVisitorNode {
    private String nsUri;

    public FeatureCapability() {
    }

    public FeatureCapability(String nsUri) {
        if (nsUri == null) {
            throw new IllegalArgumentException("null namespace");
        }
        this.nsUri = nsUri;
    }

    @XmlAttribute(name="namespace", required=true)
    public String getNsUri() {
        if (this.nsUri == null) {
            throw new IllegalStateException("null namespace value");
        }
        return this.nsUri;
    }

    public void setNsUri(String nsUri) {
        if (nsUri == null) {
            throw new IllegalArgumentException("null namespace value");
        }
        this.nsUri = nsUri;
    }

    public boolean resolves(ProfileRequirement requirement) {
        if (requirement instanceof FeatureRequirement) {
            String other = ((FeatureRequirement)requirement).getNsUri();
            return this.nsUri.equals(other);
        }
        return false;
    }

    public boolean isConsistent(ProfileCapability other) {
        if (other != null && other instanceof FeatureCapability) {
            return !this.getNsUri().equals(FeatureCapability.class.cast(other));
        }
        return true;
    }

    public void visit(ProfileMetaDataVisitor visitor) {
        visitor.addCapability((ProfileCapability)this);
    }

    public int hashCode() {
        return this.getNsUri().hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getSimpleName());
        buffer.append("{namespace=").append(this.nsUri).append("}");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FeatureCapability)) {
            return false;
        }
        FeatureCapability other = (FeatureCapability)obj;
        return FeatureCapability.equals(this.nsUri, other.nsUri);
    }

    private static boolean equals(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null && two != null) {
            return false;
        }
        return one.equals(two);
    }
}

