/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.resolver;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.profileservice.dependency.ProfileControllerContext;
import org.jboss.profileservice.dependency.ProfileRequirementDependencyItem;
import org.jboss.profileservice.repository.ProfileMetaDataContext;
import org.jboss.profileservice.resolver.ProfileNodeDependency;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.activation.ProfileActivationConfiguration;
import org.jboss.profileservice.spi.dependency.ProfileCapability;
import org.jboss.profileservice.spi.dependency.ProfileRequirement;
import org.jboss.profileservice.spi.metadata.ProfileFeatureMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaDataVisitorNode;

public class ProfileResolutionNode
implements ProfileMetaDataContext {
    private final ProfileMetaDataContext delegate;
    private List<ProfileNodeDependency> iDependOn = new LinkedList<ProfileNodeDependency>();
    private ConcurrentMap<String, Set<ProfileNodeDependency>> iDependOnByName = new ConcurrentHashMap<String, Set<ProfileNodeDependency>>();
    private List<ProfileNodeDependency> dependsOnMe = new LinkedList<ProfileNodeDependency>();

    public ProfileResolutionNode(ProfileMetaDataContext ctx) {
        this.delegate = ctx;
    }

    @Override
    public ProfileKey getKey() {
        return this.delegate.getKey();
    }

    void addIDependOn(ProfileNodeDependency dependency) {
        this.iDependOn.add(dependency);
        this.iDependOnByName.putIfAbsent(dependency.getTo().getName(), new HashSet());
        ((Set)this.iDependOnByName.get(dependency.getTo().getName())).add(dependency);
    }

    public List<ProfileNodeDependency> getiDependOn() {
        return this.iDependOn;
    }

    void markAsResolved(ProfileKey key) {
        Set dependencies = (Set)this.iDependOnByName.get(key.getName());
        for (ProfileNodeDependency dependency : dependencies) {
            dependency.markAsResolved();
        }
    }

    void addDependsOnMe(ProfileNodeDependency dependency) {
        this.dependsOnMe.add(dependency);
    }

    List<ProfileNodeDependency> getDependsOnMe() {
        return this.dependsOnMe;
    }

    void hardenDependsOnMe() {
        for (ProfileNodeDependency dependency : this.dependsOnMe) {
            dependency.hardenDependency();
            dependency.hardenOptionalDependsOnTo();
        }
    }

    boolean hasDependsOnMe() {
        return this.dependsOnMe.size() > 0;
    }

    boolean checkResolved(Collection<ProfileKey> included) {
        boolean resolved = true;
        for (ProfileNodeDependency dependency : this.iDependOn) {
            ProfileKey key;
            if (dependency.isOptional() || (key = dependency.getTo()) != null && included.contains(key)) continue;
            resolved = false;
        }
        return resolved;
    }

    boolean isResolved() {
        boolean resolved = true;
        for (ProfileNodeDependency dependency : this.iDependOn) {
            if (dependency.isResolved() || dependency.isOptional()) continue;
            resolved = false;
        }
        return resolved;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ProfileResolutionNode)) {
            return false;
        }
        ProfileResolutionNode other = (ProfileResolutionNode)obj;
        return this.getKey().equals((Object)other.getKey());
    }

    public String toString() {
        return this.getKey().getName();
    }

    public void describe(ProfileControllerContext context) {
        DependencyInfo dependencyInfo = context.getDependencyInfo();
        for (ProfileNodeDependency dependency : this.iDependOn) {
            ProfileRequirement requirement = dependency.getRequirement();
            ControllerState dependentState = dependency.isRequireInstalled() ? ControllerState.INSTALLED : ControllerState.DESCRIBED;
            dependencyInfo.addIDependOn((DependencyItem)new ProfileRequirementDependencyItem(context, requirement, dependency.getTo(), dependentState));
        }
    }

    public void addAlias(String name) {
        this.delegate.addAlias(name);
    }

    public void addCapability(ProfileCapability capability) {
        this.delegate.addCapability(capability);
    }

    public void addFeature(ProfileFeatureMetaData feature) {
        this.delegate.addFeature(feature);
    }

    public void addRequirement(ProfileRequirement requirement) {
        this.delegate.addRequirement(requirement);
    }

    @Override
    public ProfileActivationConfiguration getActivationConfiguration() {
        return this.delegate.getActivationConfiguration();
    }

    @Override
    public Collection<ProfileKey> getAliases() {
        return this.delegate.getAliases();
    }

    @Override
    public Collection<ProfileCapability> getCapabilities() {
        return this.delegate.getCapabilities();
    }

    @Override
    public Collection<ProfileFeatureMetaData> getFeatures() {
        return this.delegate.getFeatures();
    }

    @Override
    public ProfileMetaData getProfileMetaData() {
        return this.delegate.getProfileMetaData();
    }

    @Override
    public String getProfileName() {
        return this.delegate.getProfileName();
    }

    @Override
    public Collection<ProfileRequirement> getRequirements() {
        return this.delegate.getRequirements();
    }

    public void visit(ProfileMetaDataVisitorNode node) {
        this.delegate.visit(node);
    }
}

