/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.management;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.deployers.spi.management.NameMatcher;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.management.event.ProfileLifeCycleEvent;
import org.jboss.profileservice.management.event.ProfileModificationEvent;
import org.jboss.profileservice.persistence.repository.PersistenceRepository;
import org.jboss.profileservice.plugins.management.actions.ProfileViewUpdateAction;
import org.jboss.profileservice.plugins.management.actions.RemoveComponentAction;
import org.jboss.profileservice.plugins.management.actions.UpdateComponentAction;
import org.jboss.profileservice.plugins.management.util.AbstractManagementProxyFactory;
import org.jboss.profileservice.plugins.management.view.RegisteredProfileView;
import org.jboss.profileservice.plugins.spi.ProfileView;
import org.jboss.profileservice.plugins.spi.ProfileViewWrapper;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.action.ActionController;
import org.jboss.profileservice.spi.action.EventBus;
import org.jboss.profileservice.spi.action.ModificationEvent;
import org.jboss.profileservice.spi.action.ModificationListener;
import org.jboss.profileservice.spi.action.ModificationStatus;
import org.jboss.profileservice.spi.action.ProfileModificationType;
import org.jboss.profileservice.spi.managed.ManagedProfile;
import org.jboss.util.collection.ConcurrentSet;

public class RegisteredProfileViewsWrapper
implements ProfileViewWrapper {
    private Set<ProfileKey> registeredKeys = new ConcurrentSet();
    private Map<ProfileKey, RegisteredProfileView> viewsByName = new ConcurrentHashMap<ProfileKey, RegisteredProfileView>();
    private AbstractManagementProxyFactory proxyFactory;
    private PersistenceRepository persistenceRepository;
    private final ActionController controller;

    public RegisteredProfileViewsWrapper(ActionController controller, PersistenceRepository persistenceRepository) {
        if (controller == null) {
            throw new IllegalArgumentException("null action controller");
        }
        if (persistenceRepository == null) {
            throw new IllegalArgumentException("null persistence repository");
        }
        this.controller = controller;
        this.persistenceRepository = persistenceRepository;
    }

    @Override
    public synchronized boolean load() {
        boolean changed = false;
        Set<ProfileKey> have = this.registeredKeys;
        this.registeredKeys = new ConcurrentSet();
        List keys = this.controller.getActiveProfiles();
        for (ProfileKey key : keys) {
            boolean exists = have.remove(key);
            this.registeredKeys.add(key);
            if (exists) continue;
            RegisteredProfileView view = this.createProfileView(key);
            this.viewsByName.put(key, view);
            this.getEventBus().addListener((ModificationListener)view);
        }
        for (ProfileKey key : have) {
            ProfileView view = this.viewsByName.remove(key);
            if (view == null) continue;
            this.getEventBus().removeListener((ModificationListener)view);
            changed = true;
        }
        for (ProfileKey key : keys) {
            RegisteredProfileView view = this.viewsByName.get(key);
            if (!view.load()) continue;
            ManagedProfile managedProfile = this.controller.getManagedProfile(key);
            ProfileViewUpdateAction action = new ProfileViewUpdateAction(managedProfile, view, this.proxyFactory);
            this.controller.perform(key, ProfileModificationType.GET, Collections.singletonList(action));
            changed = true;
        }
        return changed;
    }

    RegisteredProfileView createProfileView(ProfileKey key) {
        return new RegisteredProfileView(key);
    }

    protected Collection<RegisteredProfileView> getViews() {
        return this.viewsByName.values();
    }

    protected EventBus getEventBus() {
        return (EventBus)EventBus.class.cast(this.controller);
    }

    @Override
    public void setManagementProxyFactory(AbstractManagementProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    @Override
    public ManagedComponent getComponent(String name, ComponentType type) {
        ManagedComponent component = null;
        for (RegisteredProfileView view : this.getViews()) {
            ManagedComponent resolved = view.getComponent(name, type);
            if (resolved == null) continue;
            component = resolved;
        }
        return component;
    }

    @Override
    public Set<ComponentType> getComponentTypes() {
        HashSet<ComponentType> types = new HashSet<ComponentType>();
        for (RegisteredProfileView view : this.getViews()) {
            types.addAll(view.getComponentTypes());
        }
        return types;
    }

    @Override
    public Set<ManagedComponent> getComponentsForType(ComponentType type) {
        HashSet<ManagedComponent> components = new HashSet<ManagedComponent>();
        for (RegisteredProfileView view : this.getViews()) {
            components.addAll(view.getComponentsForType(type));
        }
        return components;
    }

    @Override
    public Collection<String> getDeploymentNames() {
        TreeSet<String> deployments = new TreeSet<String>();
        for (RegisteredProfileView view : this.getViews()) {
            deployments.addAll(view.getDeploymentNames());
        }
        return deployments;
    }

    @Override
    public Set<String> getDeploymentNamesForType(String type) {
        TreeSet<String> deployments = new TreeSet<String>();
        for (RegisteredProfileView view : this.getViews()) {
            deployments.addAll(view.getDeploymentNamesForType(type));
        }
        return deployments;
    }

    @Override
    public Set<ManagedDeployment> getDeploymentsForType(String type) {
        HashSet<ManagedDeployment> deployments = new HashSet<ManagedDeployment>();
        for (RegisteredProfileView view : this.getViews()) {
            deployments.addAll(view.getDeploymentsForType(type));
        }
        return deployments;
    }

    @Override
    public ManagedDeployment getManagedDeployment(String name) {
        ManagedDeployment deployment = null;
        for (RegisteredProfileView view : this.getViews()) {
            ManagedDeployment resolved = view.getManagedDeployment(name);
            if (resolved == null) continue;
            deployment = resolved;
        }
        return deployment;
    }

    @Override
    public Set<ManagedComponent> getMatchingComponents(String name, ComponentType type, NameMatcher<ManagedComponent> matcher) {
        HashSet<ManagedComponent> components = new HashSet<ManagedComponent>();
        for (RegisteredProfileView view : this.getViews()) {
            components.addAll(view.getMatchingComponents(name, type, matcher));
        }
        return components;
    }

    @Override
    public Set<String> getMatchingDeploymentName(String regex) {
        TreeSet<String> deployments = new TreeSet<String>();
        for (RegisteredProfileView view : this.getViews()) {
            deployments.addAll(view.getMatchingDeploymentName(regex));
        }
        return deployments;
    }

    @Override
    public Set<ManagedDeployment> getMatchingDeployments(String name, NameMatcher<ManagedDeployment> matcher) {
        HashSet<ManagedDeployment> deployments = new HashSet<ManagedDeployment>();
        for (RegisteredProfileView view : this.getViews()) {
            deployments.addAll(view.getMatchingDeployments(name, matcher));
        }
        return deployments;
    }

    public void notify(ModificationEvent event) {
        ProfileLifeCycleEvent lifeCycle;
        if (!(event instanceof ProfileLifeCycleEvent) || (lifeCycle = (ProfileLifeCycleEvent)ProfileLifeCycleEvent.class.cast(event)).getState() == ProfileLifeCycleEvent.LifeCycleState.UNINSTALLED) {
            // empty if block
        }
    }

    public ProfileKey resolveProfile(String deploymentName) {
        for (RegisteredProfileView view : this.getViews()) {
            if (!view.getDeploymentNames().contains(deploymentName)) continue;
            return view.getKey();
        }
        return null;
    }

    @Override
    public void removeComponent(ManagedComponent update, ManagedComponent original) throws Exception {
        ManagedDeployment deployment = original.getDeployment();
        ProfileKey key = this.resolveProfile(deployment.getName());
        RemoveComponentAction updateComponentAction = new RemoveComponentAction(original, this.persistenceRepository, null);
        ArrayList<RemoveComponentAction> actions = new ArrayList<RemoveComponentAction>();
        actions.add(updateComponentAction);
        ModificationStatus status = this.controller.perform(key, ProfileModificationType.UPDATE, actions);
        this.getEventBus().fireModificationEvent((ModificationEvent)new ProfileModificationEvent(ProfileModificationType.DELETE, key));
        if (status.isFailed()) {
            RegisteredProfileViewsWrapper.rethrowAsException(status.getFailure());
        }
    }

    @Override
    public void updateComponent(ManagedComponent update, ManagedComponent original) throws Exception {
        ManagedDeployment deployment = original.getDeployment();
        ProfileKey key = this.resolveProfile(deployment.getName());
        UpdateComponentAction updateComponentAction = new UpdateComponentAction(update, original, this.proxyFactory, this.persistenceRepository, null);
        ArrayList<UpdateComponentAction> actions = new ArrayList<UpdateComponentAction>();
        actions.add(updateComponentAction);
        ModificationStatus status = this.controller.perform(key, ProfileModificationType.UPDATE, actions);
        this.getEventBus().fireModificationEvent((ModificationEvent)new ProfileModificationEvent(ProfileModificationType.UPDATE, key));
        if (status.isFailed()) {
            RegisteredProfileViewsWrapper.rethrowAsException(status.getFailure());
        }
    }

    static void rethrowAsException(Throwable t) throws Exception {
        if (t instanceof Exception) {
            throw (Exception)Exception.class.cast(t);
        }
        throw new UndeclaredThrowableException(t);
    }
}

