/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.management.view;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.deployers.spi.management.KnownComponentTypes;
import org.jboss.deployers.spi.management.NameMatcher;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.profileservice.plugins.spi.ProfileView;
import org.jboss.profileservice.plugins.spi.ProfileViewProcessingContext;
import org.jboss.profileservice.spi.action.ModificationEvent;
import org.jboss.profileservice.spi.action.ModificationListener;

public class AbstractProfileView
implements ProfileView,
ProfileViewProcessingContext,
ModificationListener {
    private Map<ComponentType, Set<ManagedComponent>> compByCompType = new HashMap<ComponentType, Set<ManagedComponent>>();
    private Map<String, ManagedDeployment> managedDeployments = new HashMap<String, ManagedDeployment>();
    private final AtomicBoolean modified = new AtomicBoolean(true);

    @Override
    public boolean load() {
        if (!this.modified.getAndSet(false)) {
            return false;
        }
        this.compByCompType.clear();
        this.managedDeployments.clear();
        return true;
    }

    @Override
    public Collection<String> getDeploymentNames() {
        return this.managedDeployments.keySet();
    }

    @Override
    public ManagedDeployment getManagedDeployment(String name) {
        ManagedDeployment deployment = this.managedDeployments.get(name);
        if (deployment == null) {
            for (ManagedDeployment d : this.managedDeployments.values()) {
                if (d.getParent() != null || !name.equals(d.getSimpleName())) continue;
                deployment = d;
                break;
            }
        }
        return deployment;
    }

    @Override
    public Set<String> getMatchingDeploymentName(String regex) {
        Collection<String> names = this.getDeploymentNames();
        HashSet<String> matches = new HashSet<String>();
        Pattern p = Pattern.compile(regex);
        for (String name : names) {
            Matcher m = p.matcher(name);
            if (!m.matches()) continue;
            matches.add(name);
        }
        return matches;
    }

    @Override
    public Set<ManagedDeployment> getMatchingDeployments(String name, NameMatcher<ManagedDeployment> matcher) {
        HashSet<ManagedDeployment> matches = new HashSet<ManagedDeployment>();
        for (ManagedDeployment deployment : this.managedDeployments.values()) {
            if (!matcher.matches((Object)deployment, name)) continue;
            matches.add(deployment);
        }
        return matches;
    }

    @Override
    public Set<String> getDeploymentNamesForType(String type) {
        TreeSet<String> matches = new TreeSet<String>();
        for (ManagedDeployment md : this.managedDeployments.values()) {
            String name = md.getName();
            Set types = md.getTypes();
            if (types == null || !types.contains(type)) continue;
            matches.add(name);
        }
        return matches;
    }

    @Override
    public ManagedComponent getComponent(String name, ComponentType type) {
        Set<ManagedComponent> components = this.compByCompType.get(type);
        if (components != null) {
            for (ManagedComponent mc : components) {
                if (!mc.getName().equals(name)) continue;
                return mc;
            }
        }
        return null;
    }

    @Override
    public Set<ComponentType> getComponentTypes() {
        return this.compByCompType.keySet();
    }

    @Override
    public Set<ManagedComponent> getComponentsForType(ComponentType type) {
        Set<Object> comps = null;
        if (type.equals((Object)KnownComponentTypes.ANY_TYPE)) {
            HashSet<ManagedComponent> all = new HashSet<ManagedComponent>();
            for (Set<ManagedComponent> typeComps : this.compByCompType.values()) {
                for (ManagedComponent comp : typeComps) {
                    all.add(comp);
                }
            }
            comps = all;
        } else {
            comps = this.compByCompType.get(type);
        }
        if (comps == null) {
            comps = Collections.emptySet();
        }
        return comps;
    }

    @Override
    public Set<ManagedDeployment> getDeploymentsForType(String type) {
        Set<String> names = this.getDeploymentNamesForType(type);
        HashSet<ManagedDeployment> mds = new HashSet<ManagedDeployment>();
        for (String name : names) {
            mds.add(this.getManagedDeployment(name));
        }
        return mds;
    }

    @Override
    public Set<ManagedComponent> getMatchingComponents(String name, ComponentType type, NameMatcher<ManagedComponent> matcher) {
        Set<ManagedComponent> components = this.compByCompType.get(type);
        HashSet<ManagedComponent> matched = new HashSet<ManagedComponent>();
        if (components != null) {
            for (ManagedComponent mc : components) {
                if (!matcher.matches((Object)mc, name)) continue;
                matched.add(mc);
            }
        }
        return matched;
    }

    @Override
    public void addManagedComponent(ManagedComponent component) {
        ComponentType type = component.getType();
        Set<ManagedComponent> components = this.compByCompType.get(type);
        if (components == null) {
            components = new HashSet<ManagedComponent>();
            this.compByCompType.put(type, components);
        }
        components.add(component);
    }

    @Override
    public void addManagedDeployment(ManagedDeployment deployment) {
        this.managedDeployments.put(deployment.getName(), deployment);
    }

    @Override
    public void addManagedObject(ManagedObject managedObject) {
        throw new IllegalStateException("unsupported operation");
    }

    public void notify(ModificationEvent event) {
    }

    public void markAsModified() {
        this.modified.set(true);
    }
}

