/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.deployer.JAXPDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.system.deployers.SARArchiveFilter;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceDeploymentClassPath;
import org.jboss.system.metadata.ServiceDeploymentParser;
import org.jboss.system.metadata.ServiceMetaDataParser;
import org.jboss.util.xml.DOMWriter;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SARDeployer
extends JAXPDeployer<ServiceDeployment> {
    private URL defaultCodeBaseRoot;

    public SARDeployer() {
        super(ServiceDeployment.class);
        this.setSuffix("-service.xml");
        this.setBuildManagedObject(true);
        this.setAllowMultipleFiles(true);
    }

    public URL getDefaultCodeBaseRoot() {
        return this.defaultCodeBaseRoot;
    }

    public void setDefaultCodeBaseRoot(URL defaultCodeBaseRoot) {
        this.defaultCodeBaseRoot = defaultCodeBaseRoot;
    }

    protected ServiceDeployment parse(VFSDeploymentUnit unit, VirtualFile file, Document document) throws Exception {
        List services;
        ServiceDeploymentParser parser = new ServiceDeploymentParser(document);
        ServiceDeployment parsed = parser.parse();
        String name = file.toURI().toString();
        parsed.setName(name);
        List classPaths = parsed.getClassPaths();
        if (classPaths != null) {
            this.processXMLClasspath(unit, classPaths);
        }
        if ((services = parsed.getServices()) == null) {
            Element config = parsed.getConfig();
            if (config == null) {
                this.log.debugf("Service deployment has no services: %1s", (Object)parsed.getName());
                return parsed;
            }
            if (this.log.isDebugEnabled()) {
                String docStr = DOMWriter.printNode((Node)config, (boolean)true);
                int index = docStr.toLowerCase().indexOf("password");
                if (index != -1) {
                    docStr = this.maskPasswords(docStr, index);
                }
                this.log.debug((Object)docStr);
            }
            ServiceMetaDataParser SMDparser = new ServiceMetaDataParser(config);
            services = SMDparser.parse();
            parsed.setServices(services);
        }
        return parsed;
    }

    private void processXMLClasspath(VFSDeploymentUnit unit, List<ServiceDeploymentClassPath> classpaths) throws Exception {
        ArrayList<VirtualFile> classpath = new ArrayList<VirtualFile>();
        for (ServiceDeploymentClassPath path : classpaths) {
            String codebase = path.getCodeBase();
            String archives = path.getArchives();
            this.log.debugf("Processing classpath: %1s codebase=%2s archives=%3s", (Object)unit.getName(), (Object)codebase, (Object)archives);
            VirtualFile codebaseFile = unit.getRoot();
            if (!".".equals(codebase)) {
                if (this.defaultCodeBaseRoot == null) {
                    throw new DeploymentException("No default codebase root for " + codebase + " in " + unit.getName());
                }
                URL codeBaseURL = new URL(this.defaultCodeBaseRoot, codebase);
                codebaseFile = VFS.getChild((URL)codeBaseURL);
            }
            if (codebaseFile == null) {
                throw new DeploymentException("Cannot use classpath without a root: " + unit.getName());
            }
            if (archives == null) {
                classpath.add(codebaseFile);
                this.log.debugf("Using codebase as classpath: %1s", (Object)unit.getName());
                continue;
            }
            SARArchiveFilter filter = new SARArchiveFilter(archives);
            List archiveFiles = codebaseFile.getChildren((VirtualFileFilter)filter);
            classpath.addAll(archiveFiles);
        }
        unit.prependClassPath(classpath);
    }

    private String maskPasswords(String original, int index) {
        StringBuilder sb = new StringBuilder(original);
        int startPasswdStringIndex = sb.indexOf(">", index);
        if (startPasswdStringIndex != -1) {
            String modified;
            int endPasswdStringIndex;
            if (sb.charAt(startPasswdStringIndex - 1) != '-' && (endPasswdStringIndex = sb.indexOf("<", startPasswdStringIndex)) != -1) {
                sb.replace(startPasswdStringIndex + 1, endPasswdStringIndex, "****");
            }
            if ((index = (modified = sb.toString()).toLowerCase().indexOf("password", startPasswdStringIndex)) != -1) {
                return this.maskPasswords(modified, index);
            }
            return modified;
        }
        return original;
    }
}

