/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.SecurityActions;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.UnknownExtensionTypeException;
import org.jboss.shrinkwrap.api.importer.ArchiveImportException;
import org.jboss.shrinkwrap.api.importer.ZipImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArchiveFactory {
    private static final String ARCHIVE_IMPL = "org.jboss.shrinkwrap.impl.base.MemoryMapArchiveImpl";
    private final Configuration configuration;

    ArchiveFactory(Configuration configuration) throws IllegalArgumentException {
        assert (configuration != null) : "configuration must be supplied";
        this.configuration = configuration;
    }

    public <T extends Assignable> T create(Class<T> type) throws IllegalArgumentException, UnknownExtensionTypeException {
        if (type == null) {
            throw new IllegalArgumentException("Type must be specified");
        }
        String extension = this.configuration.getExtensionLoader().getExtensionFromExtensionMapping(type);
        String archiveName = UUID.randomUUID().toString();
        archiveName = archiveName + extension;
        return this.create(type, archiveName);
    }

    public <T extends Assignable> T create(Class<T> type, String archiveName) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("Type must be specified");
        }
        if (archiveName == null) {
            throw new IllegalArgumentException("ArchiveName must be specified");
        }
        Archive archive = SecurityActions.newInstance(ARCHIVE_IMPL, new Class[]{String.class, Configuration.class}, new Object[]{archiveName, this.configuration}, Archive.class);
        return archive.as(type);
    }

    public <T extends Assignable> T createFromZipFile(Class<T> type, File archiveFile) throws IllegalArgumentException, ArchiveImportException {
        ZipFile zipFile;
        if (type == null) {
            throw new IllegalArgumentException("Type must be specified");
        }
        if (archiveFile == null) {
            throw new IllegalArgumentException("file must be specified");
        }
        if (!archiveFile.exists()) {
            throw new IllegalArgumentException("File for import exist: " + archiveFile.getAbsolutePath());
        }
        if (archiveFile.isDirectory()) {
            throw new IllegalArgumentException("File for import must not be a directory: " + archiveFile.getAbsolutePath());
        }
        try {
            zipFile = new ZipFile(archiveFile);
        }
        catch (ZipException ze) {
            throw new IllegalArgumentException("Does not appear to be a valid ZIP file: " + archiveFile.getAbsolutePath());
        }
        catch (IOException ioe) {
            throw new RuntimeException("I/O Error in importing new archive from ZIP: " + archiveFile.getAbsolutePath(), ioe);
        }
        return ShrinkWrap.create(type, archiveFile.getName()).as(ZipImporter.class).importZip(zipFile).as(type);
    }
}

