/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env;

import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.beans.metadata.spi.builder.ParameterMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.deployer.env.AbstractBootstrapInfoDeployer;
import org.jboss.weld.integration.deployer.env.BootstrapInfo;
import org.jboss.weld.integration.deployer.env.bda.DUTopLevelClassLoaderGetter;
import org.jboss.weld.integration.deployer.env.bda.DeploymentImpl;
import org.jboss.weld.integration.provider.JBossSingletonProvider;

public class WeldBootstrapDeployer
extends AbstractBootstrapInfoDeployer {
    private SingletonProvider singletonProvider;

    public WeldBootstrapDeployer() {
        super(false);
        this.setDisableOptional(true);
        this.addOutput(BeanMetaData.class);
        this.addInput("javax.validation.ValidatorFactory");
    }

    public void setSingletonProvider(SingletonProvider singletonProvider) {
        this.singletonProvider = singletonProvider;
    }

    public void start() {
        if (this.singletonProvider != null) {
            SingletonProvider.initialize((SingletonProvider)this.singletonProvider);
        } else {
            JBossSingletonProvider provider = new JBossSingletonProvider();
            provider.setTopLevelClassLoaderGetter(DUTopLevelClassLoaderGetter.INSTANCE);
            SingletonProvider.initialize((SingletonProvider)provider);
        }
    }

    public void stop() {
        SingletonProvider.reset();
    }

    protected void deployInternal(DeploymentUnit unit, BootstrapInfo info) throws DeploymentException {
        ValueMetaData ejbServicesValue = info.getEjbServices();
        if (ejbServicesValue == null) {
            throw new DeploymentException("Missing ejb services: " + unit);
        }
        ValueMetaData ejbInjectionServicesValue = info.getEjbInjectionServices();
        if (ejbInjectionServicesValue == null) {
            throw new DeploymentException("Missing ejb injection services: " + unit);
        }
        ValueMetaData deploymentValue = info.getDeployment();
        if (deploymentValue == null) {
            throw new DeploymentException("Missing deployment: " + unit);
        }
        String bootstrapName = DeployersUtils.getBootstrapBeanName(unit);
        BeanMetaDataBuilder bootstrap = BeanMetaDataBuilder.createBuilder((String)bootstrapName, (String)"org.jboss.weld.integration.deployer.env.helpers.BootstrapBean");
        bootstrap.addConstructorParameter(Bootstrap.class.getName(), this.createBootstrap(unit));
        bootstrap.addConstructorParameter(DeploymentImpl.class.getName(), deploymentValue);
        bootstrap.addPropertyMetaData("ejbServices", ejbServicesValue);
        bootstrap.addPropertyMetaData("ejbInjectionServices", ejbInjectionServicesValue);
        bootstrap.addPropertyMetaData("jpaServices", WeldBootstrapDeployer.createServiceConnector("JBossJpaServices", "org.jboss.weld.integration.persistence.JBossJpaServices", unit));
        bootstrap.addPropertyMetaData("resourceServices", bootstrap.createInject((Object)"JBossResourceServices"));
        bootstrap.addPropertyMetaData("transactionServices", bootstrap.createInject((Object)"JBossTransactionServices"));
        bootstrap.addPropertyMetaData("securityServices", bootstrap.createInject((Object)"JBossSecurityServices"));
        bootstrap.addPropertyMetaData("validationServices", this.createValidationServices(unit));
        bootstrap.setCreate("initialize");
        bootstrap.setStart("boot");
        bootstrap.setDestroy("shutdown");
        bootstrap.addDependency((Object)"RealTransactionManager");
        bootstrap.addDependency((Object)unit.getName());
        ParameterMetaDataBuilder install = bootstrap.addInstallWithParameters("createDepenencies", "DynamicDependencyCreator", null, ControllerState.CONFIGURED);
        install.addParameterMetaData(Object.class.getName(), bootstrapName);
        install.addParameterMetaData(Iterable.class.getName(), bootstrap.createInject(ejbServicesValue.getUnderlyingValue(), "ejbContainerNames"));
        install.addParameterMetaData(String.class.getName(), "Start");
        install.addParameterMetaData(String.class.getName(), ControllerState.PRE_INSTALL.getStateString());
        ParameterMetaDataBuilder jndiInstall = bootstrap.addInstallWithParameters("bind", "JndiBinder", ControllerState.INSTALLED, ControllerState.START);
        jndiInstall.addParameterMetaData(DeploymentUnit.class.getName(), (Object)unit);
        ParameterMetaDataBuilder jndiUninstall = bootstrap.addUninstallWithParameters("unbind", "JndiBinder");
        jndiUninstall.addParameterMetaData(DeploymentUnit.class.getName(), (Object)unit);
        unit.addAttachment(DeployersUtils.getBootstrapBeanAttachmentName(unit), (Object)bootstrap.getBeanMetaData());
    }

    protected ValueMetaData createBootstrap(DeploymentUnit unit) {
        String beanName = unit.getName() + "_WeldBootstrap";
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)beanName, (String)"org.jboss.weld.bootstrap.WeldBootstrap");
        unit.addAttachment(beanName + "_" + BeanMetaData.class.getSimpleName(), (Object)builder.getBeanMetaData());
        return builder.createInject((Object)beanName);
    }

    protected ValueMetaData createValidationServices(DeploymentUnit unit) throws DeploymentException {
        Object validatorFactory = unit.getAttachment("javax.validation.ValidatorFactory");
        if (validatorFactory == null && this.isValidationFactoryRequired(unit)) {
            throw new DeploymentException("Missing ValidatorFactory attachment in deployment: " + unit);
        }
        String beanName = unit.getName() + "_JBossValidationServices";
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)beanName, (String)"org.jboss.weld.integration.validation.JBossValidationServices");
        unit.addAttachment(beanName + "_" + BeanMetaData.class.getSimpleName(), (Object)builder.getBeanMetaData());
        builder.addConstructorParameter("javax.validation.ValidatorFactory", validatorFactory);
        return builder.createInject((Object)beanName);
    }

    protected boolean isValidationFactoryRequired(DeploymentUnit deploymentUnit) {
        return false;
    }
}

