/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.Pipe;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.management.PipeConnectionMBean;
import org.jboss.xnio.nio.NioPipeChannel;
import org.jboss.xnio.nio.NioXnio;

final class NioPipeConnection
implements Closeable {
    private final NioPipeChannel leftSide;
    private final NioPipeChannel rightSide;

    NioPipeConnection(NioXnio nioXnio) throws IOException {
        MBean mbean;
        Pipe leftToRight = Pipe.open();
        Pipe rightToLeft = Pipe.open();
        Pipe.SourceChannel leftToRightSource = leftToRight.source();
        Pipe.SinkChannel leftToRightSink = rightToLeft.sink();
        Pipe.SourceChannel rightToLeftSource = rightToLeft.source();
        Pipe.SinkChannel rightToLeftSink = leftToRight.sink();
        leftToRightSource.configureBlocking(false);
        leftToRightSink.configureBlocking(false);
        rightToLeftSource.configureBlocking(false);
        rightToLeftSink.configureBlocking(false);
        try {
            mbean = new MBean();
        }
        catch (NotCompliantMBeanException e) {
            throw new IOException("Failed to register channel mbean: " + e);
        }
        Closeable mbeanHandle = nioXnio.registerMBean(mbean);
        NioPipeChannel leftSide = NioPipeChannel.create(leftToRightSource, leftToRightSink, nioXnio, mbean.bytesRead, mbean.messagesRead, mbeanHandle);
        NioPipeChannel rightSide = NioPipeChannel.create(rightToLeftSource, rightToLeftSink, nioXnio, mbean.bytesWritten, mbean.messagesWritten, mbeanHandle);
        this.leftSide = leftSide;
        this.rightSide = rightSide;
        nioXnio.addManaged((Closeable)((Object)leftSide));
        nioXnio.addManaged((Closeable)((Object)rightSide));
    }

    public NioPipeChannel getLeftSide() {
        return this.leftSide;
    }

    public NioPipeChannel getRightSide() {
        return this.rightSide;
    }

    @Override
    public void close() throws IOException {
        IoUtils.safeClose((Closeable)((Object)this.leftSide));
        IoUtils.safeClose((Closeable)((Object)this.rightSide));
    }

    private final class MBean
    extends StandardMBean
    implements PipeConnectionMBean {
        private final AtomicLong bytesRead;
        private final AtomicLong bytesWritten;
        private final AtomicLong messagesRead;
        private final AtomicLong messagesWritten;

        private MBean() throws NotCompliantMBeanException {
            super(PipeConnectionMBean.class);
            this.bytesRead = new AtomicLong();
            this.bytesWritten = new AtomicLong();
            this.messagesRead = new AtomicLong();
            this.messagesWritten = new AtomicLong();
        }

        public long getBytesRead() {
            return this.bytesRead.get();
        }

        public long getMessagesRead() {
            return this.messagesRead.get();
        }

        public long getBytesWritten() {
            return this.bytesWritten.get();
        }

        public long getMessagesWritten() {
            return this.messagesWritten.get();
        }

        public void close() {
            IoUtils.safeClose((Closeable)NioPipeConnection.this);
        }
    }
}

