/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.alarm;

import javax.management.ObjectName;
import org.jboss.monitor.alarm.Alarm;
import org.jboss.monitor.alarm.AlarmNotification;

public class AlarmTableNotification
extends AlarmNotification {
    public static final String ALARM_TABLE_UPDATE = "jboss.alarm.table.update";
    private static final long serialVersionUID = -2307598716282112101L;
    private String alarmId;
    private boolean ackState;
    private long ackTime;
    private String ackUser;
    private String ackSystem;

    public AlarmTableNotification(String alarmId, String type, Object source, ObjectName target, int severity, int alarmState, long sequenceNumber, long timeStamp, String message) {
        super(type, source, target, severity, alarmState, sequenceNumber, timeStamp, message);
        this.alarmId = alarmId;
    }

    public AlarmTableNotification(AlarmTableNotification atn) {
        super(atn.getType(), atn.getSource(), atn.getTarget(), atn.getSeverity(), atn.getAlarmState(), atn.getSequenceNumber(), atn.getTimeStamp(), atn.getMessage());
        this.setUserData(atn.getUserData());
        this.alarmId = atn.alarmId;
        this.ackState = atn.ackState;
        this.ackTime = atn.ackTime;
        this.ackUser = atn.ackUser;
        this.ackSystem = atn.ackSystem;
    }

    public String getAlarmId() {
        return this.alarmId;
    }

    public boolean getAckState() {
        return this.ackState;
    }

    public long getAckTime() {
        return this.ackTime;
    }

    public String getAckUser() {
        return this.ackUser;
    }

    public String getAckSystem() {
        return this.ackSystem;
    }

    public void setAckParams(boolean ackState, long ackTime, String ackUser, String ackSystem) {
        this.ackState = ackState;
        this.ackTime = ackTime;
        this.ackUser = ackUser;
        this.ackSystem = ackSystem;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(256);
        sbuf.append(AlarmTableNotification.class.getName());
        sbuf.append(" [ alarmId=").append(this.alarmId);
        sbuf.append(", type=").append(this.getType());
        sbuf.append(", source=").append(this.getSource());
        sbuf.append(", target=").append(this.getTarget());
        sbuf.append(", severity=").append(Alarm.SEVERITY_STRINGS[this.getSeverity()]);
        sbuf.append(", alarmState=").append(Alarm.STATE_STRINGS[this.getAlarmState()]);
        sbuf.append(", sequenceNumber=").append(this.getSequenceNumber());
        sbuf.append(", timeStamp=").append(this.getTimeStamp());
        sbuf.append(", message=").append(this.getMessage());
        sbuf.append(", userData={").append(this.getUserData());
        sbuf.append("}, ackState=").append(this.ackState);
        sbuf.append(", ackTime=").append(this.ackTime);
        sbuf.append(", ackUser=").append(this.ackUser);
        sbuf.append(", ackSystem=").append(this.ackSystem);
        sbuf.append(" ]");
        return sbuf.toString();
    }
}

