/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.persistence.component;

import java.util.ArrayList;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.profileservice.persistence.ManagedObjectPersistencePlugin;
import org.jboss.profileservice.persistence.PersistenceFactory;
import org.jboss.profileservice.persistence.component.ComponentMapper;
import org.jboss.profileservice.persistence.xml.ModificationInfo;
import org.jboss.profileservice.persistence.xml.PersistedComponent;
import org.jboss.profileservice.persistence.xml.PersistedManagedObject;
import org.jboss.profileservice.persistence.xml.PersistedProperty;

public abstract class AbstractComponentMapper
implements ComponentMapper {
    private final PersistenceFactory persistenceFactory;

    public AbstractComponentMapper(PersistenceFactory persistenceFactory) {
        if (persistenceFactory == null) {
            throw new IllegalArgumentException("null persistence factory");
        }
        this.persistenceFactory = persistenceFactory;
    }

    public ManagedObjectPersistencePlugin getPersistencePlugin() {
        return this.persistenceFactory.getPersistencePlugin();
    }

    public ManagedObjectFactory getMOF() {
        return this.persistenceFactory.getManagedObjectFactory();
    }

    @Override
    public void restoreComponent(Object attachment, PersistedComponent component) {
        if (attachment == null) {
            throw new IllegalArgumentException("null attachment");
        }
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        ModificationInfo modification = component.getModificationInfo();
        if (modification == null) {
            modification = ModificationInfo.MODIFIED;
        }
        switch (modification) {
            case ADDED: {
                this.updateComponent(attachment, component, true);
                break;
            }
            case MODIFIED: {
                this.updateComponent(attachment, component, false);
                break;
            }
            case REMOVED: {
                this.removeComponent(attachment, component);
            }
        }
    }

    @Override
    public PersistedComponent addComponent(Object attachment, ManagedComponent component) {
        return this.createPersistedComponent(attachment, component, ModificationInfo.ADDED);
    }

    @Override
    public PersistedComponent updateComponent(Object attachment, ManagedComponent component) {
        return this.createPersistedComponent(attachment, component, ModificationInfo.MODIFIED);
    }

    @Override
    public PersistedComponent removeComponent(Object attachment, ManagedComponent component) {
        PersistedComponent persisted = this.createPersistedComponent(attachment, component, ModificationInfo.REMOVED);
        persisted.setProperties(new ArrayList<PersistedProperty>());
        return persisted;
    }

    protected abstract void removeComponent(Object var1, PersistedComponent var2);

    protected abstract ManagedObject getComponent(Object var1, PersistedComponent var2, boolean var3);

    protected PersistedComponent createComponent(Object attachment, ManagedComponent component) {
        ManagedObject mo = (ManagedObject)component.getParent();
        PersistedManagedObject persisted = this.getPersistencePlugin().createPersistedManagedObject(mo);
        PersistedComponent persistedComponent = new PersistedComponent(persisted);
        this.setComponentName(persistedComponent, mo);
        return persistedComponent;
    }

    protected abstract void setComponentName(PersistedComponent var1, ManagedObject var2);

    protected void updateComponent(Object attachment, PersistedComponent component, boolean added) {
        ManagedObject mo = this.getComponent(attachment, component, added);
        this.getPersistencePlugin().updateManagedObject(component, mo);
    }

    protected PersistedComponent createPersistedComponent(Object attachment, ManagedComponent component, ModificationInfo modification) {
        if (attachment == null) {
            throw new IllegalArgumentException("null attachment");
        }
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (modification == null) {
            throw new IllegalArgumentException("null modification info");
        }
        PersistedComponent persisted = this.createComponent(attachment, component);
        persisted.setModificationInfo(modification);
        return persisted;
    }
}

