/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.jndi;

import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.jboss.logging.Logger;

public abstract class JavaCompJndiBinder {
    protected Logger log = Logger.getLogger(this.getClass());
    private String applicationName;
    private String moduleName;

    public JavaCompJndiBinder(String applicationName, String moduleName) {
        this.applicationName = applicationName;
        this.moduleName = moduleName;
    }

    public void bindToJavaComp() {
        try {
            Context compContext = this.getJavaCompContext();
            BeanManager beanManagerContext = null;
            try {
                beanManagerContext = (BeanManager)compContext.lookup("BeanManager");
            }
            catch (NamingException e) {
                // empty catch block
            }
            if (beanManagerContext == null) {
                String path = this.applicationName == null ? this.applicationName : this.applicationName + "/" + this.moduleName;
                compContext.bind("BeanManager", (Object)new LinkRef("java:global/cdi/" + path + "/BeanManager"));
            }
        }
        catch (NamingException e) {
            this.log.error((Object)("Could not bound BeanManager on " + this.getJavaContextDescription()));
        }
    }

    protected abstract Context getJavaCompContext() throws NamingException;

    protected abstract String getJavaContextDescription();

    public void unbind() {
        try {
            this.getJavaCompContext().unbind("BeanManager");
        }
        catch (NamingException e) {
            this.log.error((Object)("Cound not unbind java:comp/BeanManager for " + this.getJavaContextDescription()));
        }
    }
}

