/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import java.util.List;
import org.jboss.aop.AspectManager;
import org.jboss.aop.microcontainer.beans.CFlowStackEntry;
import org.jboss.aop.pointcut.CFlow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFlowStack {
    private AspectManager manager;
    private String name;
    private List<CFlowStackEntry> entries;

    public AspectManager getManager() {
        return this.manager;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<CFlowStackEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<CFlowStackEntry> entries) {
        this.entries = entries;
    }

    public void start() {
        if (this.name == null || this.name.length() == 0) {
            throw new IllegalArgumentException("Null name");
        }
        if (this.entries == null || this.entries.size() == 0) {
            throw new IllegalArgumentException("No entries");
        }
        org.jboss.aop.pointcut.CFlowStack stack = new org.jboss.aop.pointcut.CFlowStack(this.name);
        for (CFlowStackEntry entry : this.entries) {
            boolean notCalled = !entry.getCalled();
            stack.addCFlow(new CFlow(entry.getExpr(), notCalled));
        }
        this.manager.addCFlowStack(stack);
    }

    public void stop() {
        this.manager.removeCFlowStack(this.name);
    }
}

