/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.agent.bundle;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import org.rhq.core.domain.bundle.BundleResourceDeployment;

public class BundleScheduleRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BundleResourceDeployment resourceDeployment;
    private long requestedDeployTime = System.currentTimeMillis();
    private boolean isCleanDeployment = false;
    private boolean isRevert = false;

    public BundleScheduleRequest(BundleResourceDeployment resourceDeployment) {
        this.resourceDeployment = resourceDeployment;
    }

    public BundleResourceDeployment getBundleResourceDeployment() {
        return this.resourceDeployment;
    }

    public Long getRequestedDeployTime() {
        return this.requestedDeployTime;
    }

    public String getRequestedDeployTimeAsString() {
        return DateFormat.getInstance().format(new Date(this.requestedDeployTime));
    }

    public boolean isCleanDeployment() {
        return this.isCleanDeployment;
    }

    public void setCleanDeployment(boolean isCleanDeployment) {
        this.isCleanDeployment = isCleanDeployment;
    }

    public boolean isRevert() {
        return this.isRevert;
    }

    public void setRevert(boolean isRevert) {
        this.isRevert = isRevert;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getClass() + ": ");
        str.append("deployment=[").append(this.resourceDeployment.toString()).append("], ");
        str.append("clean=[").append(this.isCleanDeployment).append("], ");
        str.append("revert=[").append(this.isRevert).append("]");
        return str.toString();
    }
}

