/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.async.spi;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.ejb3.async.spi.AsyncEndpoint;
import org.jboss.ejb3.async.spi.AsyncInvocationId;
import org.jboss.logging.Logger;

public class AsynchronousClientFuture<V>
extends FutureTask<V>
implements Future<V> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AsynchronousClientFuture.class);
    private final AsyncInvocationId id;
    private final AsyncEndpoint container;

    public AsynchronousClientFuture(Callable<V> callable, AsyncInvocationId id, AsyncEndpoint container) {
        super(callable);
        assert (id != null) : "Async invocation ID must be specified";
        this.id = id;
        assert (container != null) : "Container must be supplied";
        this.container = container;
    }

    public AsynchronousClientFuture(Runnable runnable, V result, AsyncInvocationId id, AsyncEndpoint container) {
        super(runnable, result);
        assert (id != null) : "Async invocation ID must be specified";
        this.id = id;
        assert (container != null) : "Container must be supplied";
        this.container = container;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Blocking request to get()");
        }
        Object returnValueFromBeanProvider = super.get();
        V wrappedValue = this.getWrappedFuture(returnValueFromBeanProvider);
        return wrappedValue;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Request to get() with timeout " + timeout + " (" + (Object)((Object)unit) + ")"));
        }
        Object returnValueFromBeanProvider = super.get(timeout, unit);
        V wrappedValue = this.getWrappedFuture(returnValueFromBeanProvider);
        return wrappedValue;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        boolean returnValue = super.cancel(false);
        if (!returnValue && mayInterruptIfRunning) {
            this.container.cancel(this.id);
            returnValue = true;
        }
        return returnValue;
    }

    private V getWrappedFuture(Object returnValueFromBeanProvider) throws InterruptedException, ExecutionException {
        if (returnValueFromBeanProvider == null) {
            return null;
        }
        if (!(returnValueFromBeanProvider instanceof Future)) {
            throw new RuntimeException("Bean provider has not specified a return value of type " + Future.class.getName() + ", was instead: " + returnValueFromBeanProvider);
        }
        Future result = (Future)returnValueFromBeanProvider;
        Object unwrappedReturnValue = result.get();
        return unwrappedReturnValue;
    }
}

