/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.metadata;

import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.metadata.MetaDataResolver;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.util.PayloadKey;

public class ThreadMetaData
implements MetaDataResolver {
    ThreadLocal<SimpleMetaData> metaData = new ThreadLocal();
    private static final ThreadMetaData me = new ThreadMetaData();

    public void addMetaData(Object tag, Object attr, Object value) {
        this.addMetaData(tag, attr, value, PayloadKey.MARSHALLED);
    }

    public void addMetaData(Object tag, Object attr, Object value, PayloadKey type) {
        SimpleMetaData data = this.metaData.get();
        if (data == null) {
            data = new SimpleMetaData();
            this.metaData.set(data);
        }
        data.addMetaData(tag, attr, value, type);
    }

    public Object getMetaData(Object tag, Object attr) {
        SimpleMetaData data = this.metaData.get();
        if (data == null) {
            return null;
        }
        return data.getMetaData(tag, attr);
    }

    public synchronized void removeMetaData(Object tag, Object attr) {
        SimpleMetaData data = this.metaData.get();
        if (data == null) {
            return;
        }
        data.removeMetaData(tag, attr);
    }

    public synchronized void removeGroupData(Object tag) {
        SimpleMetaData data = this.metaData.get();
        if (data == null) {
            return;
        }
        data.removeGroupData(tag);
    }

    public Object resolve(Invocation invocation, Object tag, Object attr) {
        return this.getMetaData(tag, attr);
    }

    public SimpleMetaData getAllMetaData(Invocation invocation) {
        return this.metaData.get();
    }

    public void clear() {
        this.metaData.set(null);
    }

    public static ThreadMetaData instance() {
        return me;
    }
}

