/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.javaee;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.client.jboss.JBossClientMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEntityBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.javaee.jboss.NamedModule;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEModuleInformer;

public class SimpleJavaEEModuleIdentifier {
    private static final String[] REQUIRED_ATTACHMENTS = new String[]{JBossClientMetaData.class.getName(), JBossMetaData.class.getName(), JBossWebMetaData.class.getName(), NamedModule.class.getName()};

    public JavaEEModuleInformer.ModuleType getModuleType(DeploymentUnit unit) {
        if (unit.isAttachmentPresent(JBossClientMetaData.class)) {
            return JavaEEModuleInformer.ModuleType.APP_CLIENT;
        }
        if (unit.isAttachmentPresent(JBossMetaData.class) && this.isReallyAnEjbDeployment(unit)) {
            return JavaEEModuleInformer.ModuleType.EJB;
        }
        if (unit.isAttachmentPresent(JBossWebMetaData.class)) {
            return JavaEEModuleInformer.ModuleType.WEB;
        }
        return JavaEEModuleInformer.ModuleType.JAVA;
    }

    public String getModuleName(DeploymentUnit unit) {
        NamedModule moduleName = (NamedModule)unit.getAttachment(NamedModule.class);
        return moduleName == null ? null : moduleName.getModuleName();
    }

    public String[] getRequiredAttachments() {
        return REQUIRED_ATTACHMENTS;
    }

    private boolean isReallyAnEjbDeployment(DeploymentUnit unit) {
        JBossMetaData metaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        if (metaData.getEnterpriseBeans() == null || metaData.getEnterpriseBeans().size() == 0) {
            return false;
        }
        for (JBossEnterpriseBeanMetaData bean : metaData.getEnterpriseBeans()) {
            if (bean instanceof JBossEntityBeanMetaData) continue;
            return true;
        }
        return false;
    }
}

