/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.classloading.spi.metadata.ClassLoadingDomainMetaData;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.version.Version;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployment.EARDeployment;
import org.jboss.deployment.EarClassLoaderDeployerMBean;
import org.jboss.deployment.LoaderRepositoryMetaDataHelper;
import org.jboss.metadata.common.jboss.LoaderRepositoryMetaData;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JMX(name="jboss.j2ee:service=EARClassLoaderDeployer", exposedInterface=EarClassLoaderDeployerMBean.class)
public class EarClassLoaderDeployer
extends AbstractSimpleRealDeployer<JBossAppMetaData>
implements EarClassLoaderDeployerMBean {
    private boolean isolated = false;

    @Override
    public boolean isIsolated() {
        return this.isolated;
    }

    @Override
    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public EarClassLoaderDeployer() {
        super(JBossAppMetaData.class);
        this.addInput(ClassLoadingDomainMetaData.class);
        this.setOutput(ClassLoadingMetaData.class);
        this.setStage(DeploymentStages.POST_PARSE);
        this.setTopLevelOnly(true);
    }

    public void deploy(DeploymentUnit unit, JBossAppMetaData metaData) throws DeploymentException {
        ClassLoadingMetaData classLoadingMetaData = (ClassLoadingMetaData)unit.getAttachment(ClassLoadingMetaData.class);
        if (classLoadingMetaData != null) {
            return;
        }
        LoaderRepositoryMetaData lrmd = metaData.getLoaderRepository();
        if (lrmd != null && LoaderRepositoryMetaDataHelper.create(unit, lrmd) != null) {
            return;
        }
        if (this.isolated) {
            String domain = null;
            ClassLoadingDomainMetaData cldmd = (ClassLoadingDomainMetaData)unit.getAttachment(ClassLoadingDomainMetaData.class);
            if (cldmd != null) {
                String name = cldmd.getName();
                domain = name == null || "<unknown>".equals(name) ? unit.getName() : name;
            }
            if (domain == null) {
                domain = EARDeployment.getJMXName(metaData, unit) + ",extension=LoaderRepository";
                try {
                    ObjectName canonical = ObjectName.getInstance(domain);
                    domain = canonical.getCanonicalName();
                }
                catch (MalformedObjectNameException ignored) {
                    // empty catch block
                }
            }
            classLoadingMetaData = new ClassLoadingMetaData();
            classLoadingMetaData.setName(unit.getName());
            classLoadingMetaData.setDomain(domain);
            classLoadingMetaData.setExportAll(ExportAll.NON_EMPTY);
            classLoadingMetaData.setImportAll(true);
            classLoadingMetaData.setVersion((Object)Version.DEFAULT_VERSION);
            classLoadingMetaData.setJ2seClassLoadingCompliance(false);
            unit.addAttachment(ClassLoadingMetaData.class, (Object)classLoadingMetaData);
        }
    }
}

