/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.policies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jacorb.config.Configuration;
import org.jacorb.orb.policies.PolicyUtil;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA._PolicyManagerLocalBase;
import org.slf4j.Logger;

public class PolicyManager
extends _PolicyManagerLocalBase {
    private final Map policy_overrides = new HashMap();
    private final Logger logger;

    public PolicyManager(Configuration configuration) {
        this.logger = configuration.getLogger("jacorb.orb.policies");
    }

    public synchronized Policy[] get_policy_overrides(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Argument may not be null");
        }
        if (nArray.length == 0) {
            return this.policy_overrides.values().toArray(new Policy[0]);
        }
        ArrayList<Policy> arrayList = new ArrayList<Policy>();
        for (int i = 0; i < nArray.length; ++i) {
            Policy policy = (Policy)this.policy_overrides.get(ObjectUtil.newInteger(nArray[i]));
            if (policy == null) continue;
            arrayList.add(policy);
        }
        Policy[] policyArray = arrayList.toArray(new Policy[0]);
        if (this.logger.isDebugEnabled() && policyArray.length > 0) {
            this.logger.debug("get_policy_overrides returns " + policyArray.length + " policies");
        }
        return policyArray;
    }

    public synchronized void set_policy_overrides(Policy[] policyArray, SetOverrideType setOverrideType) throws InvalidPolicies {
        if (policyArray == null) {
            throw new IllegalArgumentException("Argument may not be null");
        }
        HashMap<Integer, Policy> hashMap = new HashMap<Integer, Policy>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < policyArray.length; ++i) {
            if (!PolicyUtil.isInvocationPolicy(policyArray[i].policy_type())) {
                throw new NO_PERMISSION("Not an invocation policy, type " + policyArray[i].policy_type());
            }
            Integer n = ObjectUtil.newInteger(policyArray[i].policy_type());
            if (hashMap.put(n, policyArray[i]) != null) {
                throw new BAD_PARAM("Multiple policies of type " + policyArray[i].policy_type(), 30, CompletionStatus.COMPLETED_NO);
            }
            stringBuffer.append(" " + policyArray[i].policy_type());
        }
        if (setOverrideType == SetOverrideType.SET_OVERRIDE) {
            PolicyUtil.checkValidity(hashMap);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SET_OVERRIDE, types: " + stringBuffer.toString());
            }
            this.policy_overrides.clear();
            this.policy_overrides.putAll(hashMap);
        } else if (setOverrideType == SetOverrideType.ADD_OVERRIDE) {
            HashMap<Integer, Policy> hashMap2 = new HashMap<Integer, Policy>(this.policy_overrides);
            hashMap2.putAll(this.policy_overrides);
            hashMap2.putAll(hashMap);
            PolicyUtil.checkValidity(hashMap2);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ADD_OVERRIDE, types: " + stringBuffer.toString());
            }
            this.policy_overrides.clear();
            this.policy_overrides.putAll(hashMap2);
        }
    }
}

