/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;

@DeprecatedProperty(names={"suspect_on_send_failure", "skip_suspected_members"})
public abstract class BasicTCP
extends TP {
    @Property(description="Reaper interval in msec. Default is 0 (no reaping)")
    protected long reaper_interval = 0L;
    @Property(description="Max time connection can be idle before being reaped (in ms)")
    protected long conn_expire_time = 0L;
    @Property(description="Should separate send queues be used for each connection")
    boolean use_send_queues = true;
    @Property(description="Max number of messages in a send queue")
    int send_queue_size = 10000;
    @Property(description="Receiver buffer size in bytes")
    int recv_buf_size = 150000;
    @Property(description="Send buffer size in bytes")
    int send_buf_size = 150000;
    @Property(description="Max time allowed for a socket creation in connection table")
    int sock_conn_timeout = 2000;
    @Property(description="Max time to block on reading of peer address")
    int peer_addr_read_timeout = 1000;
    @Property(description="Should TCP no delay flag be turned on")
    boolean tcp_nodelay = true;
    @Property(description="SO_LINGER in msec. Default of -1 disables it")
    int linger = -1;
    @Property(description="Use \"external_addr\" if you have hosts on different networks, behind firewalls. On each firewall, set up a port forwarding rule (sometimes called \"virtual server\") to the local IP (e.g. 192.168.1.100) of the host then on each host, set \"external_addr\" TCP transport parameter to the external (public IP) address of the firewall.")
    InetAddress external_addr = null;

    protected BasicTCP() {
    }

    @Override
    public boolean supportsMulticasting() {
        return false;
    }

    public long getReaperInterval() {
        return this.reaper_interval;
    }

    public void setReaperInterval(long reaper_interval) {
        this.reaper_interval = reaper_interval;
    }

    public long getConnExpireTime() {
        return this.conn_expire_time;
    }

    public void setConnExpireTime(long conn_expire_time) {
        this.conn_expire_time = conn_expire_time;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (!this.isSingleton() && this.bind_port <= 0) {
            Protocol dynamic_discovery_prot = this.stack.findProtocol("MPING");
            if (dynamic_discovery_prot == null) {
                dynamic_discovery_prot = this.stack.findProtocol("TCPGOSSIP");
            }
            if (dynamic_discovery_prot != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("dynamic discovery is present (" + dynamic_discovery_prot + "), so start_port=" + this.bind_port + " is okay");
                }
            } else {
                throw new IllegalArgumentException("start_port cannot be set to " + this.bind_port + ", as no dynamic discovery protocol (e.g. MPING or TCPGOSSIP) has been detected.");
            }
        }
    }

    @Override
    public void sendMulticast(byte[] data, int offset, int length) throws Exception {
        this.sendToAllPhysicalAddresses(data, offset, length);
    }

    @Override
    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("dest=" + dest + " (" + length + " bytes)");
        }
        this.send(dest, data, offset, length);
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("connections: ").append(this.printConnections()).append("\n");
        return sb.toString();
    }

    public abstract String printConnections();

    public abstract void send(Address var1, byte[] var2, int var3, int var4) throws Exception;

    public abstract void retainAll(Collection<Address> var1);

    @Override
    public void receive(Address sender, byte[] data, int offset, int length) {
        super.receive(sender, data, offset, length);
    }

    @Override
    protected Object handleDownEvent(Event evt) {
        Object ret = super.handleDownEvent(evt);
        if (evt.getType() == 6) {
            HashSet<Address> physical_mbrs = new HashSet<Address>();
            for (Address addr : this.members) {
                PhysicalAddress physical_addr = this.getPhysicalAddressFromCache(addr);
                if (physical_addr == null) continue;
                physical_mbrs.add(physical_addr);
            }
            this.retainAll(physical_mbrs);
        }
        return ret;
    }
}

