/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.instantiator.deployer;

import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.instantiator.spi.BeanInstantiator;
import org.jboss.ejb3.instantiator.spi.BeanInstantiatorRegistration;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;

public abstract class BeanInstantiatorDeployerBase
extends AbstractDeployer {
    private static final Logger log = Logger.getLogger(BeanInstantiatorDeployerBase.class);
    private Kernel kernel;
    private JavaEEComponentInformer javaEEComponentInformer;

    public BeanInstantiatorDeployerBase() {
        this.addInput(JBossMetaData.class);
        this.addOutput(BeanInstantiator.class);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!this.isEjb3ModuleDeployment(unit)) {
            return;
        }
        JBossEnterpriseBeansMetaData ejbs = this.getEjbModuleMetadata(unit);
        assert (ejbs != null) : "No EJBs found in this deployment, the deployer should have skipped this operation earlier";
        for (JBossEnterpriseBeanMetaData ejb : ejbs) {
            BeanInstantiator instantiator = this.getBeanInstantiator(ejb);
            if (instantiator == null) {
                throw new IllegalStateException("Bean instantiator implemenentation was not supplied");
            }
            String mcBindName = this.getRegistrationNameFromDeploymentUnit(unit, ejb);
            BeanMetaDataBuilder bmdb = BeanMetaDataBuilderFactory.createBuilder((String)mcBindName, (String)BeanInstantiator.class.getName());
            this.processMetadata(bmdb, unit, ejb);
            try {
                this.kernel.getController().install(bmdb.getBeanMetaData(), (Object)instantiator);
            }
            catch (Throwable e) {
                throw new DeploymentException("Could not install bean instantiator", e);
            }
            log.debug((Object)("Installed " + instantiator + " into MC at " + mcBindName));
        }
    }

    public void undeploy(DeploymentUnit unit) {
        if (!this.isEjb3ModuleDeployment(unit)) {
            return;
        }
        JBossEnterpriseBeansMetaData ejbs = this.getEjbModuleMetadata(unit);
        assert (ejbs != null) : "No EJBs found in this deployment, the deployer should have skipped this operation earlier";
        for (JBossEnterpriseBeanMetaData ejb : ejbs) {
            String mcBindName = this.getRegistrationNameFromDeploymentUnit(unit, ejb);
            ControllerContext context = this.kernel.getController().uninstall((Object)mcBindName);
            log.debug((Object)("Uninstalled " + context.getTarget() + " from MC at " + mcBindName));
        }
    }

    protected void processMetadata(BeanMetaDataBuilder beanMetaDataBuilder, DeploymentUnit unit, JBossEnterpriseBeanMetaData ejb) {
    }

    protected abstract BeanInstantiator getBeanInstantiator(JBossEnterpriseBeanMetaData var1);

    private JBossEnterpriseBeansMetaData getEjbModuleMetadata(DeploymentUnit unit) {
        assert (unit != null) : "Deployment Unit must be specified";
        JBossMetaData md = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        if (md == null) {
            return null;
        }
        JBossEnterpriseBeansMetaData ejbs = md.getEnterpriseBeans();
        return ejbs;
    }

    boolean isEjb3ModuleDeployment(DeploymentUnit unit) {
        JBossEnterpriseBeansMetaData ejbs = this.getEjbModuleMetadata(unit);
        if (ejbs == null) {
            return false;
        }
        return ejbs.getEjbJarMetaData().isEJB3x();
    }

    @Inject
    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    @Inject
    public void setJavaEEComponentInformer(JavaEEComponentInformer informer) {
        this.javaEEComponentInformer = informer;
    }

    private String getRegistrationNameFromDeploymentUnit(DeploymentUnit unit, JBossEnterpriseBeanMetaData ejb) {
        assert (unit != null) : "unit must be specified";
        String appName = this.javaEEComponentInformer.getApplicationName(unit);
        String moduleName = this.javaEEComponentInformer.getModuleName(unit);
        String registrationName = BeanInstantiatorRegistration.getInstantiatorRegistrationName((String)appName, (String)moduleName, (String)ejb.getName());
        return registrationName;
    }
}

