/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.remoting.Version;
import org.jboss.remoting.serialization.IMarshalledValue;

public abstract class SerializationManager {
    public ObjectInputStream createRegularInput(InputStream input) throws IOException {
        ClassLoader tcl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return this.createInput(input, tcl);
    }

    public abstract ObjectInputStream createInput(InputStream var1, ClassLoader var2) throws IOException;

    public abstract ObjectOutputStream createOutput(OutputStream var1) throws IOException;

    public abstract IMarshalledValue createdMarshalledValue(Object var1) throws IOException;

    public void sendObject(ObjectOutputStream output, Object dataObject) throws IOException {
        int version = Version.getDefaultVersion();
        this.sendObject(output, dataObject, version);
    }

    public abstract void sendObject(ObjectOutputStream var1, Object var2, int var3) throws IOException;

    public abstract IMarshalledValue createMarshalledValueForClone(Object var1) throws IOException;

    public Object receiveObject(InputStream input, ClassLoader customClassLoader) throws IOException, ClassNotFoundException {
        int version = Version.getDefaultVersion();
        return this.receiveObject(input, customClassLoader, version);
    }

    public abstract Object receiveObject(InputStream var1, ClassLoader var2, int var3) throws IOException, ClassNotFoundException;
}

