/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.addons.transports.httpserver;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.http.AbstractHTTPTransportFactory;
import org.jboss.wsf.stack.cxf.addons.transports.httpserver.HttpServerDestination;
import org.jboss.wsf.stack.cxf.addons.transports.httpserver.HttpServerEngineFactory;

public class HttpServerTransportFactory
extends AbstractHTTPTransportFactory
implements DestinationFactory {
    private Map<String, HttpServerDestination> destinations = new ConcurrentHashMap<String, HttpServerDestination>();

    @Resource
    public void setBus(Bus b) {
        super.setBus(b);
    }

    @PostConstruct
    public void finalizeConfig() {
        if (null == this.bus) {
            return;
        }
        this.getServerEngineFactory();
    }

    protected HttpServerEngineFactory getServerEngineFactory() {
        HttpServerEngineFactory serverEngineFactory = (HttpServerEngineFactory)this.getBus().getExtension(HttpServerEngineFactory.class);
        if (serverEngineFactory == null) {
            serverEngineFactory = new HttpServerEngineFactory(this.bus);
            serverEngineFactory.setBus(this.getBus());
        }
        return serverEngineFactory;
    }

    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        HttpServerDestination destination;
        String addr = endpointInfo.getAddress();
        HttpServerDestination httpServerDestination = destination = addr == null ? null : this.destinations.get(addr);
        if (destination == null) {
            destination = this.createDestination(endpointInfo);
        }
        return destination;
    }

    private synchronized HttpServerDestination createDestination(EndpointInfo endpointInfo) throws IOException {
        HttpServerDestination destination;
        String addr = endpointInfo.getAddress();
        HttpServerDestination httpServerDestination = destination = addr == null ? null : this.destinations.get(addr);
        if (destination == null) {
            destination = new HttpServerDestination(this.getBus(), this, endpointInfo);
            this.destinations.put(endpointInfo.getAddress(), destination);
            this.configure((Object)destination);
            destination.finalizeConfig();
        }
        return destination;
    }

    void removeDestination(EndpointInfo ei) {
        this.destinations.remove(ei.getAddress());
    }
}

