/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.async.impl.interceptor;

import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ejb.EJBException;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.async.impl.SerializableFuture;
import org.jboss.ejb3.async.impl.interceptor.CurrentAsyncAOPInvocation;
import org.jboss.ejb3.async.spi.AsyncInvocationId;
import org.jboss.ejb3.async.spi.AsyncInvocationMap;
import org.jboss.ejb3.async.spi.CurrentAsyncInvocation;
import org.jboss.ejb3.mdb.MessagingContainer;
import org.jboss.ejb3.service.ServiceContainer;
import org.jboss.ejb3.session.SessionSpecContainer;
import org.jboss.logging.Logger;

public class AsynchronousServerInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AsynchronousServerInterceptor.class);

    public AsynchronousServerInterceptor() {
        log.debug((Object)("Created: " + this));
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        AsyncInvocationId id = CurrentAsyncAOPInvocation.getCurrentAsyncInvocationId((Invocation)invocation);
        Advisor advisor = invocation.getAdvisor();
        Object ejbContainer = EJBContainer.getEJBContainer(advisor);
        if (ejbContainer instanceof ServiceContainer || ejbContainer instanceof MessagingContainer) {
            return invocation.invokeNext();
        }
        SessionSpecContainer sessionContainer = (SessionSpecContainer)EJBContainer.getEJBContainer(advisor);
        AsyncInvocationMap currentInvocations = sessionContainer.getCurrentAsyncInvocations();
        if (id != null) {
            currentInvocations.put((Object)id, (Object)false);
        }
        CurrentAsyncInvocation.markCurrentInvocationOnThread((AsyncInvocationId)id);
        try {
            Object returnValue = invocation.invokeNext();
            if (returnValue instanceof Future) {
                Future future = (Future)returnValue;
                if (!(returnValue instanceof Serializable)) {
                    returnValue = new SerializableFuture(future.get());
                }
            }
            Object object = returnValue;
            return object;
        }
        finally {
            if (id != null) {
                currentInvocations.remove((Object)id);
            }
            CurrentAsyncInvocation.unmarkCurrentInvocationFromThread();
        }
    }

    private static class ExceptionFuture<V>
    implements Future<V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final EJBException exception;

        public ExceptionFuture(Exception exception) {
            assert (exception != null) : "Exception must be specified";
            this.exception = new EJBException(exception);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            throw new ExecutionException(this.exception);
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new ExecutionException(this.exception);
        }
    }
}

