/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.ejb3.annotation.DeliveryMode;
import org.jboss.ejb3.mdb.ProducerManager;
import org.jboss.logging.Logger;

public class ProducerManagerImpl
implements ProducerManager,
Externalizable,
Interceptor {
    private static final long serialVersionUID = -3096930718616437880L;
    private static final Logger log = Logger.getLogger(ProducerManagerImpl.class);
    private static final int PERSISTENT = 2;
    private static final int NON_PERSISTENT = 1;
    protected Destination destination;
    protected String factoryLookup;
    protected int deliveryMode = 2;
    protected int timeToLive = 0;
    protected int priority = 4;
    protected HashMap methodMap;
    protected transient ConnectionFactory factory;
    protected transient Connection connection;
    protected transient Session session;
    protected transient MessageProducer msgProducer;
    protected transient String username;
    protected transient String password;
    protected transient InitialContext initialContext;
    protected Hashtable initialContextProperties;
    protected boolean transacted;
    protected int acknowledgeMode;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.destination);
        out.writeObject(this.factoryLookup);
        out.writeInt(this.deliveryMode);
        out.writeInt(this.timeToLive);
        out.writeInt(this.priority);
        out.writeObject(this.methodMap);
        out.writeObject(this.initialContextProperties);
        if (this.factoryLookup == null) {
            out.writeObject(this.factory);
        }
        out.writeBoolean(this.transacted);
        out.writeInt(this.acknowledgeMode);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.destination = (Destination)in.readObject();
        this.factoryLookup = (String)in.readObject();
        this.deliveryMode = in.readInt();
        this.timeToLive = in.readInt();
        this.priority = in.readInt();
        this.methodMap = (HashMap)in.readObject();
        this.initialContextProperties = (Hashtable)in.readObject();
        try {
            this.initialContext = InitialContextFactory.getInitialContext(this.initialContextProperties);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        if (this.factoryLookup != null) {
            try {
                this.factory = (ConnectionFactory)this.initialContext.lookup(this.factoryLookup);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.factory = (ConnectionFactory)in.readObject();
        }
        this.transacted = in.readBoolean();
        this.acknowledgeMode = in.readInt();
    }

    public ProducerManagerImpl(Destination destination, ConnectionFactory factory, DeliveryMode deliveryMode, int timeToLive, int priority, HashMap methodMap, Hashtable initialContextProperties, boolean transacted, int acknowledgeMode) {
        this.init(destination, deliveryMode, timeToLive, priority, methodMap, initialContextProperties, transacted, acknowledgeMode);
        this.factory = factory;
    }

    public ProducerManagerImpl(Destination destination, String factory, DeliveryMode deliveryMode, int timeToLive, int priority, HashMap methodMap, Hashtable initialContextProperties, boolean transacted, int acknowledgeMode) {
        this.init(destination, deliveryMode, timeToLive, priority, methodMap, initialContextProperties, transacted, acknowledgeMode);
        this.factoryLookup = factory;
    }

    private void init(Destination destination, DeliveryMode deliveryMode, int timeToLive, int priority, HashMap methodMap, Hashtable initialContextProperties, boolean transacted, int acknowledgeMode) {
        this.initialContextProperties = initialContextProperties;
        try {
            this.initialContext = InitialContextFactory.getInitialContext(initialContextProperties);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        this.destination = destination;
        int mode = deliveryMode.ordinal();
        switch (mode) {
            case 2: {
                this.deliveryMode = 2;
                break;
            }
            case 1: {
                this.deliveryMode = 1;
            }
        }
        this.timeToLive = timeToLive;
        this.priority = priority;
        this.methodMap = methodMap;
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
    }

    public ProducerManagerImpl() {
    }

    @Override
    public void setUsername(String user) {
        this.username = user;
    }

    @Override
    public void setPassword(String passwd) {
        this.password = passwd;
    }

    @Override
    public void connect() throws JMSException {
        if (this.factory == null) {
            try {
                this.factory = (ConnectionFactory)this.initialContext.lookup(this.factoryLookup);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.connection != null) {
            return;
        }
        this.connection = this.username != null ? this.factory.createConnection(this.username, this.password) : this.factory.createConnection();
        this.session = this.connection.createSession(this.transacted, this.acknowledgeMode);
        this.msgProducer = this.session.createProducer(this.destination);
        this.msgProducer.setDeliveryMode(this.deliveryMode);
        this.msgProducer.setTimeToLive((long)this.timeToLive);
        this.msgProducer.setPriority(this.priority);
    }

    @Override
    public void close() throws JMSException {
        this.msgProducer.close();
        this.msgProducer = null;
        this.session.close();
        this.session = null;
        this.connection.close();
        this.connection = null;
    }

    @Override
    public void commit() throws JMSException {
        this.session.commit();
    }

    @Override
    public void rollback() throws JMSException {
        this.session.rollback();
    }

    public String getName() {
        return ProducerManager.class.getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.session == null) {
            throw new RuntimeException("You must call connect() on the producer.  The JMS session has not been set");
        }
        ObjectMessage msg = this.session.createObjectMessage((Serializable)invocation);
        this.msgProducer.send((Message)msg, this.deliveryMode, this.priority, (long)this.timeToLive);
        return null;
    }
}

