/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.statistics;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class InvocationStatistics
implements Serializable {
    private static final long serialVersionUID = -1637309757441812924L;
    private Map<String, TimeStatistic> methodStats;
    public AtomicLong concurrentCalls = new AtomicLong();
    public volatile long maxConcurrentCalls = 0L;
    public long lastResetTime = System.currentTimeMillis();

    public InvocationStatistics() {
        this.methodStats = new ConcurrentHashMap<String, TimeStatistic>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStats(Method m, long elapsed) {
        TimeStatistic stat = this.methodStats.get(m.getName());
        if (stat == null) {
            Map<String, TimeStatistic> map = this.methodStats;
            synchronized (map) {
                stat = this.methodStats.get(m.getName());
                if (stat == null) {
                    stat = new TimeStatistic();
                    this.methodStats.put(m.getName(), stat);
                }
            }
        }
        stat.count.incrementAndGet();
        stat.totalTime.addAndGet(elapsed);
        if (stat.minTime > elapsed) {
            stat.minTime = elapsed;
        }
        if (stat.maxTime < elapsed) {
            stat.maxTime = elapsed;
        }
    }

    public void callIn() {
        long calls = this.concurrentCalls.incrementAndGet();
        if (calls > this.maxConcurrentCalls) {
            this.maxConcurrentCalls = calls;
        }
    }

    public void callOut() {
        this.concurrentCalls.decrementAndGet();
    }

    public synchronized void resetStats() {
        this.methodStats.clear();
        this.maxConcurrentCalls = 0L;
        this.lastResetTime = System.currentTimeMillis();
    }

    public Map<String, TimeStatistic> getStats() {
        return Collections.unmodifiableMap(this.methodStats);
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("InvocationStatistics concurrentCalls='");
        tmp.append(this.concurrentCalls);
        tmp.append("'\n");
        HashMap<String, TimeStatistic> copy = new HashMap<String, TimeStatistic>(this.methodStats);
        for (Map.Entry<String, TimeStatistic> entry : copy.entrySet()) {
            TimeStatistic stat = entry.getValue();
            if (stat == null) continue;
            tmp.append("method name='");
            tmp.append(entry.getKey());
            tmp.append("' count='");
            tmp.append(stat.count);
            tmp.append("' minTime='");
            tmp.append(stat.minTime);
            tmp.append("' maxTime='");
            tmp.append(stat.maxTime);
            tmp.append("' totalTime='");
            tmp.append(stat.totalTime);
            tmp.append("' \n");
        }
        return tmp.toString();
    }

    public String toXmlString() {
        StringBuffer tmp = new StringBuffer("<InvocationStatistics concurrentCalls='");
        tmp.append(this.concurrentCalls);
        tmp.append("' >\n");
        HashMap<String, TimeStatistic> copy = new HashMap<String, TimeStatistic>(this.methodStats);
        for (Map.Entry<String, TimeStatistic> entry : copy.entrySet()) {
            TimeStatistic stat = entry.getValue();
            if (stat == null) continue;
            tmp.append("<method name='");
            tmp.append(entry.getKey());
            tmp.append("' count='");
            tmp.append(stat.count);
            tmp.append("' minTime='");
            tmp.append(stat.minTime);
            tmp.append("' maxTime='");
            tmp.append(stat.maxTime);
            tmp.append("' totalTime='");
            tmp.append(stat.totalTime);
            tmp.append("' />\n");
        }
        tmp.append("</InvocationStatistics>");
        return tmp.toString();
    }

    public class TimeStatistic
    implements Serializable {
        private static final long serialVersionUID = -3717837456831579570L;
        private AtomicLong count = new AtomicLong();
        private volatile long minTime = Long.MAX_VALUE;
        private volatile long maxTime;
        private AtomicLong totalTime = new AtomicLong();

        public long getCount() {
            return this.count.get();
        }

        public long getMaxTime() {
            return this.maxTime;
        }

        public long getMinTime() {
            return this.minTime;
        }

        public long getTotalTime() {
            return this.totalTime.get();
        }

        public void reset() {
            this.count.set(0L);
            this.minTime = Long.MAX_VALUE;
            this.maxTime = 0L;
            this.totalTime.set(0L);
        }
    }
}

