/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.jacc.PolicyConfiguration;
import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
import org.jboss.beans.metadata.plugins.AbstractSupplyMetaData;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployment.dependency.ContainerDependencyMetaData;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.MCDependencyPolicy;
import org.jboss.ejb3.deployers.JBoss5DependencyPolicy;
import org.jboss.ejb3.deployers.JBoss5DeploymentScope;
import org.jboss.ejb3.deployers.JBossASKernel;
import org.jboss.ejb3.javaee.JavaEEApplication;
import org.jboss.ejb3.javaee.JavaEEComponent;
import org.jboss.ejb3.service.ServiceContainer;
import org.jboss.injection.injector.EEInjector;
import org.jboss.injection.injector.metadata.EnvironmentEntryType;
import org.jboss.injection.injector.metadata.JndiEnvironmentRefsGroup;
import org.jboss.injection.manager.spi.InjectionManager;
import org.jboss.injection.manager.spi.Injector;
import org.jboss.injection.mc.metadata.JndiEnvironmentImpl;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary;
import org.jboss.metadata.ejb.spec.InterceptorMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.switchboard.spi.Barrier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3JBoss5Deployment
extends Ejb3Deployment {
    private static Logger log = Logger.getLogger(Ejb3JBoss5Deployment.class);
    private org.jboss.deployers.structure.spi.DeploymentUnit jbossUnit;
    private Map<String, ContainerDependencyMetaData> endpoints;

    public Ejb3JBoss5Deployment(DeploymentUnit ejb3Unit, Kernel kernel, MBeanServer mbeanServer, org.jboss.deployers.structure.spi.DeploymentUnit jbossUnit, JBoss5DeploymentScope deploymentScope, JBossMetaData metaData) {
        super(jbossUnit, ejb3Unit, (DeploymentScope)deploymentScope, metaData);
        this.jbossUnit = jbossUnit;
        this.kernelAbstraction = new JBossASKernel(kernel, mbeanServer);
        this.mbeanServer = mbeanServer;
        org.jboss.deployers.structure.spi.DeploymentUnit topUnit = jbossUnit.getTopLevel();
        this.endpoints = (Map)topUnit.getAttachment("MappedReferenceMetaDataResolverDeployer.endpointMap");
    }

    protected PolicyConfiguration createPolicyConfiguration() throws Exception {
        return null;
    }

    protected void putJaccInService(PolicyConfiguration pc, DeploymentUnit ejb3Unit) {
    }

    public DependencyPolicy createDependencyPolicy(JavaEEComponent component) {
        return new JBoss5DependencyPolicy(component);
    }

    public JavaEEApplication getApplication() {
        JavaEEApplication app = super.getApplication();
        if (((JBoss5DeploymentScope)app).isEar()) {
            return app;
        }
        return null;
    }

    protected void registerEJBContainer(Container container) throws Exception {
        InjectionManager injectionManager;
        MCDependencyPolicy dependsPolicy = (MCDependencyPolicy)container.getDependencyPolicy();
        EJBContainer ejbContainer = (EJBContainer)container;
        JBossEnterpriseBeanMetaData beanMD = ejbContainer.getXml();
        ContainerDependencyMetaData cdmd = null;
        if (this.endpoints != null) {
            String ejbKey = "ejb/" + this.jbossUnit.getRelativePath() + "#" + container.getEjbName();
            cdmd = this.endpoints.get(ejbKey);
        } else {
            log.warn((Object)(this.jbossUnit + " has no ContainerDependencyMetaData attachment"));
        }
        if (cdmd != null) {
            for (String jndiName : cdmd.getJndiNames()) {
                String supplyName = "jndi:" + jndiName;
                AbstractSupplyMetaData supply = new AbstractSupplyMetaData((Object)supplyName);
                dependsPolicy.getSupplies().add(supply);
            }
        }
        this.generateContainerName(container, beanMD);
        Barrier switchBoard = this.getSwitchBoardBarrier(container);
        if (switchBoard == null) {
            throw new RuntimeException("No SwitchBoard Barrier found for bean: " + container.getEjbName() + " in unit: " + this.jbossUnit + " (or its component deployment unit)");
        }
        dependsPolicy.addDependency(this.createSwitchBoardDependency(ejbContainer, switchBoard));
        log.debug((Object)("Added dependency on Switchboard " + switchBoard.getId() + " for EJB container " + ejbContainer.getName()));
        if (ejbContainer instanceof ServiceContainer) {
            this.setupDependencyOnOtherBarriers((ServiceContainer)ejbContainer);
        }
        if ((injectionManager = this.getInjectionManager(container)) == null) {
            throw new RuntimeException("No InjectionManager found for bean: " + container.getEjbName() + " in unit: " + this.jbossUnit + " (or its component deployment unit)");
        }
        this.setupInjectors(ejbContainer, injectionManager, switchBoard);
        ejbContainer.setInjectionManager(injectionManager);
        super.registerEJBContainer(container);
    }

    private void generateContainerName(Container container, JBossEnterpriseBeanMetaData beanMD) {
        ObjectName on = container.getObjectName();
        assert (on != null) : "ObjectName was null";
        beanMD.setGeneratedContainerName(on.getCanonicalName());
    }

    private static EjbDeploymentSummary getUnitSummary(DeploymentUnit unit, JBossEnterpriseBeanMetaData beanMD) {
        ClassLoader loader = unit.getClassLoader();
        EjbDeploymentSummary summary = new EjbDeploymentSummary();
        summary.setBeanMD(beanMD);
        summary.setBeanClassName(beanMD.getEjbClass());
        summary.setDeploymentName(unit.getShortName());
        String baseName = unit.getRootFile().getName();
        summary.setDeploymentScopeBaseName(baseName);
        summary.setEjbName(beanMD.getEjbName());
        summary.setLoader(loader);
        summary.setLocal(beanMD.isMessageDriven());
        if (beanMD instanceof JBossSessionBeanMetaData) {
            JBossSessionBeanMetaData sbeanMD = (JBossSessionBeanMetaData)beanMD;
            summary.setStateful(sbeanMD.isStateful());
        }
        summary.setService(beanMD.isService());
        return summary;
    }

    protected Barrier getSwitchBoardBarrier(Container container) {
        if (this.isSharedENC(this.jbossUnit)) {
            return (Barrier)this.jbossUnit.getAttachment(Barrier.class);
        }
        String ejbComponentName = JBossEnterpriseBeanMetaData.class.getName() + "." + container.getEjbName();
        org.jboss.deployers.structure.spi.DeploymentUnit componentDU = this.jbossUnit.getComponent(ejbComponentName);
        if (componentDU == null) {
            throw new RuntimeException("Component Deployment Unit for bean: " + container.getEjbName() + " not found in unit: " + this.jbossUnit);
        }
        return (Barrier)componentDU.getAttachment(Barrier.class);
    }

    protected InjectionManager getInjectionManager(Container container) {
        String ejbComponentName = JBossEnterpriseBeanMetaData.class.getName() + "." + container.getEjbName();
        org.jboss.deployers.structure.spi.DeploymentUnit componentDU = this.jbossUnit.getComponent(ejbComponentName);
        if (componentDU == null) {
            throw new RuntimeException("Component Deployment Unit for bean: " + container.getEjbName() + " not found in unit: " + this.jbossUnit);
        }
        return (InjectionManager)componentDU.getAttachment(InjectionManager.class);
    }

    protected void setupInjectors(EJBContainer ejbContainer, InjectionManager injectionManager, Barrier switchBoard) {
        InterceptorsMetaData interceptors;
        JBossEnterpriseBeanMetaData beanMetaData = ejbContainer.getXml();
        JndiEnvironmentImpl jndiEnvironment = new JndiEnvironmentImpl((Environment)beanMetaData, ejbContainer.getClassloader());
        if (this.hasInjectionTargets((JndiEnvironmentRefsGroup)jndiEnvironment)) {
            EEInjector eeInjector = new EEInjector((JndiEnvironmentRefsGroup)jndiEnvironment);
            injectionManager.addInjector((Injector)eeInjector);
            String injectorMCBeanName = this.getInjectorMCBeanNamePrefix() + ",bean=" + ejbContainer.getEjbName();
            BeanMetaData injectorBMD = this.createInjectorBMD(injectorMCBeanName, eeInjector, switchBoard);
            this.jbossUnit.addAttachment(BeanMetaData.class + ":" + injectorMCBeanName, (Object)injectorBMD);
            DependencyPolicy dependsPolicy = ejbContainer.getDependencyPolicy();
            dependsPolicy.addDependency(injectorMCBeanName);
            log.debug((Object)("Added Injector dependency: " + injectorMCBeanName + " for EJB: " + ejbContainer.getEjbName() + " in unit " + this.jbossUnit));
        }
        if ((interceptors = JBossMetaData.getInterceptors((String)beanMetaData.getEjbName(), (JBossMetaData)beanMetaData.getJBossMetaData())) == null || interceptors.isEmpty()) {
            return;
        }
        for (InterceptorMetaData interceptor : interceptors) {
            JndiEnvironmentImpl jndiEnvironmentForInterceptor;
            if (interceptor == null || !this.hasInjectionTargets((JndiEnvironmentRefsGroup)(jndiEnvironmentForInterceptor = new JndiEnvironmentImpl((Environment)interceptor, ejbContainer.getClassloader())))) continue;
            EEInjector lazyEEInjector = new EEInjector((JndiEnvironmentRefsGroup)jndiEnvironmentForInterceptor);
            injectionManager.addInjector((Injector)lazyEEInjector);
            String interceptorInjectorMCBeanName = this.getInjectorMCBeanNamePrefix() + ",bean=" + ejbContainer.getEjbName() + ",interceptor=" + interceptor.getName();
            BeanMetaData injectorBMD = this.createInjectorBMD(interceptorInjectorMCBeanName, lazyEEInjector, switchBoard);
            this.jbossUnit.addAttachment(BeanMetaData.class + ":" + interceptorInjectorMCBeanName, (Object)injectorBMD);
            DependencyPolicy dependsPolicy = ejbContainer.getDependencyPolicy();
            dependsPolicy.addDependency(interceptorInjectorMCBeanName);
            log.debug((Object)("Added Injector dependency: " + interceptorInjectorMCBeanName + " for interceptor " + interceptor.getName() + " of EJB: " + ejbContainer.getEjbName() + " in unit " + this.jbossUnit));
        }
    }

    private boolean hasInjectionTargets(JndiEnvironmentRefsGroup jndiEnv) {
        Collection envEntries = jndiEnv.getEntries();
        if (envEntries == null || envEntries.isEmpty()) {
            return false;
        }
        for (EnvironmentEntryType envEntry : envEntries) {
            Collection injectionTargets = envEntry.getInjectionTargets();
            if (injectionTargets == null || injectionTargets.isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected BeanMetaData createInjectorBMD(String injectorMCBeanName, EEInjector injector, Barrier barrier) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)injectorMCBeanName, (String)injector.getClass().getName());
        builder.setConstructorValue((Object)injector);
        builder.addDemand((Object)barrier.getId(), ControllerState.CREATE, ControllerState.START, null);
        return builder.getBeanMetaData();
    }

    protected String getInjectorMCBeanNamePrefix() {
        StringBuilder sb = new StringBuilder("jboss-injector:");
        org.jboss.deployers.structure.spi.DeploymentUnit topLevelUnit = this.jbossUnit.isTopLevel() ? this.jbossUnit : this.jbossUnit.getTopLevel();
        sb.append("topLevelUnit=");
        sb.append(topLevelUnit.getSimpleName());
        sb.append(",");
        sb.append("unit=");
        sb.append(this.jbossUnit.getSimpleName());
        return sb.toString();
    }

    private boolean isSharedENC(org.jboss.deployers.structure.spi.DeploymentUnit deploymentUnit) {
        JBossMetaData jbossMetaData = (JBossMetaData)deploymentUnit.getAttachment(JBossMetaData.class);
        JBossWebMetaData jbosswebMetaData = (JBossWebMetaData)deploymentUnit.getAttachment(JBossWebMetaData.class);
        return jbossMetaData != null && jbosswebMetaData != null;
    }

    private DemandMetaData createSwitchBoardDependency(EJBContainer container, Barrier switchBoard) {
        AbstractDemandMetaData switchboardDependency = new AbstractDemandMetaData();
        switchboardDependency.setDemand((Object)switchBoard.getId());
        switchboardDependency.setWhenRequired(ControllerState.CREATE);
        if (container instanceof ServiceContainer) {
            switchboardDependency.setTargetState(ControllerState.INSTALLED);
        } else {
            switchboardDependency.setTargetState(ControllerState.START);
        }
        return switchboardDependency;
    }

    private void setupDependencyOnOtherBarriers(ServiceContainer serviceContainer) {
        MCDependencyPolicy dependsPolicy = (MCDependencyPolicy)serviceContainer.getDependencyPolicy();
        Set<String> barriers = this.getBarrierIdsFromAllDeploymentUnitsInHierarchy(this.jbossUnit);
        for (String barrier : barriers) {
            if (barrier == null) continue;
            AbstractDemandMetaData switchboardDependency = new AbstractDemandMetaData();
            switchboardDependency.setDemand((Object)barrier);
            switchboardDependency.setWhenRequired(ControllerState.CREATE);
            switchboardDependency.setTargetState(ControllerState.INSTALLED);
            dependsPolicy.addDependency((DemandMetaData)switchboardDependency);
        }
    }

    private Set<String> getBarrierIdsFromAllDeploymentUnitsInHierarchy(org.jboss.deployers.structure.spi.DeploymentUnit deploymentUnit) {
        HashSet<String> barriers = new HashSet<String>();
        org.jboss.deployers.structure.spi.DeploymentUnit topLevelDU = deploymentUnit.getTopLevel();
        ArrayList<org.jboss.deployers.structure.spi.DeploymentUnit> allDUs = new ArrayList<org.jboss.deployers.structure.spi.DeploymentUnit>();
        allDUs.add(topLevelDU);
        allDUs.addAll(this.getChildrenRecursively(topLevelDU));
        for (org.jboss.deployers.structure.spi.DeploymentUnit du : allDUs) {
            Barrier barrier = (Barrier)du.getAttachment(Barrier.class);
            if (barrier == null) continue;
            barriers.add(barrier.getId());
        }
        return barriers;
    }

    private List<org.jboss.deployers.structure.spi.DeploymentUnit> getChildrenRecursively(org.jboss.deployers.structure.spi.DeploymentUnit deploymentUnit) {
        List componentDUs;
        ArrayList<org.jboss.deployers.structure.spi.DeploymentUnit> allChildren = new ArrayList<org.jboss.deployers.structure.spi.DeploymentUnit>();
        List children = deploymentUnit.getChildren();
        if (children != null && !children.isEmpty()) {
            allChildren.addAll(children);
            for (org.jboss.deployers.structure.spi.DeploymentUnit child : children) {
                if (child == null) continue;
                allChildren.addAll(this.getChildrenRecursively(child));
            }
        }
        if ((componentDUs = deploymentUnit.getComponents()) != null && !componentDUs.isEmpty()) {
            allChildren.addAll(componentDUs);
            for (org.jboss.deployers.structure.spi.DeploymentUnit componentDU : componentDUs) {
                if (componentDU == null) continue;
                allChildren.addAll(this.getChildrenRecursively(componentDU));
            }
        }
        return allChildren;
    }
}

