/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.client;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;
import org.jboss.injection.DependsHandler;
import org.jboss.injection.EJBInjectionHandler;
import org.jboss.injection.EncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.JndiInjectHandler;
import org.jboss.injection.PersistenceUnitHandler;
import org.jboss.injection.ResourceHandler;
import org.jboss.injection.WebServiceRefHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.client.jboss.JBossClientMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.util.NotImplementedException;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientContainer
implements InjectionContainer {
    private static final Logger log = Logger.getLogger(ClientContainer.class);
    private Class<?> mainClass;
    private JBossClientMetaData xml;
    private String applicationClientName;
    private List<Injector> injectors = new ArrayList<Injector>();
    private Map<String, Map<AccessibleObject, Injector>> encInjections = new HashMap<String, Map<AccessibleObject, Injector>>();
    private Map<String, EncInjector> encInjectors = new HashMap<String, EncInjector>();
    private Context enc;
    private Context encEnv;
    private List<Method> postConstructs = new ArrayList<Method>();

    public ClientContainer(JBossClientMetaData xml, Class<?> mainClass, String applicationClientName) throws Exception {
        this.xml = xml;
        this.mainClass = mainClass;
        this.applicationClientName = applicationClientName;
        InitialContext ctx = InitialContextFactory.getInitialContext();
        this.enc = (Context)ctx.lookup(applicationClientName);
        log.debug((Object)("Client ENC(" + applicationClientName + "):"));
        NamingEnumeration<NameClassPair> e = this.enc.list("");
        while (e.hasMore()) {
            NameClassPair ncp = e.next();
            log.debug((Object)("  " + ncp));
        }
        this.processMetadata(null);
        for (EncInjector encInjector : this.encInjectors.values()) {
            log.trace((Object)("encInjector: " + encInjector));
        }
        for (Injector injector : this.injectors) {
            log.trace((Object)("injector: " + injector));
            injector.inject((Object)null);
        }
        this.postConstruct();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass, Class<?> clazz) {
        return clazz.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass, Class<?> clazz, Method method) {
        return method.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass, Method method) {
        return method.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass, Class<?> clazz, Field field) {
        return field.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass, Field field) {
        return field.getAnnotation(annotationClass);
    }

    @Override
    public ClassLoader getClassloader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public DependencyPolicy getDependencyPolicy() {
        throw new RuntimeException("NYI");
    }

    @Override
    public String getDeploymentDescriptorType() {
        return "application-client.xml";
    }

    public String getEjbJndiName(Class businessInterface) throws NameNotFoundException {
        throw new RuntimeException("NYI");
    }

    @Override
    public String getEjbJndiName(String link, Class<?> businessInterface) {
        throw new NotImplementedException();
    }

    @Override
    public Context getEnc() {
        return this.enc;
    }

    @Override
    public Map<String, Map<AccessibleObject, Injector>> getEncInjections() {
        return this.encInjections;
    }

    @Override
    public Map<String, EncInjector> getEncInjectors() {
        return this.encInjectors;
    }

    @Override
    public RemoteEnvironment getEnvironmentRefGroup() {
        return this.xml;
    }

    @Override
    public String getIdentifier() {
        return this.applicationClientName;
    }

    @Override
    public List<Injector> getInjectors() {
        throw new NotImplementedException();
    }

    public Class<?> getMainClass() {
        return this.mainClass;
    }

    @Override
    public PersistenceUnitDeployment getPersistenceUnitDeployment(String unitName) throws NameNotFoundException {
        throw new NotImplementedException();
    }

    @Override
    public boolean hasJNDIBinding(String jndiName) {
        return false;
    }

    public void invokeMain(String[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class[] parameterTypes = new Class[]{args.getClass()};
        Method method = this.mainClass.getDeclaredMethod("main", parameterTypes);
        method.invoke(null, new Object[]{args});
    }

    private void postConstruct() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        log.info((Object)("postConstructs = " + this.postConstructs));
        for (Method method : this.postConstructs) {
            method.setAccessible(true);
            Object instance = Modifier.isStatic(method.getModifiers()) ? null : method.getDeclaringClass().newInstance();
            Object[] args = null;
            method.invoke(instance, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMetadata(DependencyPolicy dependencyPolicy) throws Exception {
        log.debug((Object)"processMetadata");
        this.processPostConstructs();
        ArrayList handlers = new ArrayList();
        handlers.add(new EJBInjectionHandler());
        handlers.add(new DependsHandler());
        handlers.add(new JndiInjectHandler());
        handlers.add(new PersistenceUnitHandler());
        handlers.add(new ResourceHandler(false));
        handlers.add(new WebServiceRefHandler());
        for (InjectionHandler injectionHandler : handlers) {
            injectionHandler.loadXml(this.xml, this);
        }
        Map<AccessibleObject, Injector> tmp = InjectionUtil.processAnnotations(this, handlers, this.getMainClass());
        this.injectors.addAll(tmp.values());
    }

    private void processPostConstructs() throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        this.processPostConstructs(this.mainClass);
        LifecycleCallbacksMetaData callbacks = this.xml.getPostConstructs();
        if (callbacks != null) {
            for (LifecycleCallbackMetaData callback : callbacks) {
                String className = callback.getClassName();
                String methodName = callback.getMethodName();
                Class<?> lifecycleClass = className == null ? this.mainClass : Thread.currentThread().getContextClassLoader().loadClass(className);
                Class[] parameterTypes = new Class[]{};
                Method method = lifecycleClass.getDeclaredMethod(methodName, parameterTypes);
                this.postConstructs.add(method);
            }
        }
    }

    private void processPostConstructs(Class<?> cls) {
        if (cls == null) {
            return;
        }
        for (Method method : cls.getDeclaredMethods()) {
            PostConstruct postConstruct = method.getAnnotation(PostConstruct.class);
            if (postConstruct == null) continue;
            if (this.postConstructs.size() > 0) {
                throw new IllegalStateException("only one @PostConstruct allowed");
            }
            this.postConstructs.add(method);
        }
        this.processPostConstructs(cls.getSuperclass());
    }

    public Container resolveEjbContainer(String link, Class businessIntf) {
        log.warn((Object)("resolveEjbContainer(" + link + ", " + businessIntf + ") not implemented"));
        return null;
    }

    public Container resolveEjbContainer(Class businessIntf) throws NameNotFoundException {
        return null;
    }

    @Override
    public String resolveMessageDestination(String link) {
        return null;
    }

    @Override
    public VirtualFile getRootFile() {
        throw new NotImplementedException();
    }
}

