/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.session;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.proxy.EJBMetaDataImpl;
import org.jboss.ejb3.proxy.handle.HomeHandleImpl;
import org.jboss.ejb3.session.BaseSessionRemoteProxy;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSessionProxyFactory
implements ProxyFactory,
Externalizable {
    private static final Logger log = Logger.getLogger(BaseSessionProxyFactory.class);
    private EJBContainer container;
    protected String containerGuid;
    protected String containerClusterUid;
    protected boolean isClustered = false;

    public BaseSessionProxyFactory() {
    }

    protected BaseSessionProxyFactory(SessionContainer container) {
        assert (container != null) : "container is null";
        this.setContainer(container);
    }

    @Override
    public Object createHomeProxy() {
        throw new RuntimeException("NYI");
    }

    protected void setContainer(Container container) {
        this.container = (EJBContainer)container;
        this.containerGuid = Ejb3Registry.guid(container);
        this.containerClusterUid = Ejb3Registry.clusterUid(container);
        this.isClustered = container.isClustered();
    }

    protected Container getContainer() {
        if (this.container == null) {
            this.container = (EJBContainer)Ejb3Registry.findContainer(this.containerGuid);
            if (this.container == null && this.isClustered) {
                this.container = (EJBContainer)Ejb3Registry.getClusterContainer(this.containerClusterUid);
            }
        }
        return this.container;
    }

    protected void setEjb21Objects(BaseSessionRemoteProxy proxy) {
        proxy.setHandle(this.getHandle());
        proxy.setHomeHandle(this.getHomeHandle());
        proxy.setEjbMetaData(this.getEjbMetaData());
    }

    protected abstract Handle getHandle();

    protected HomeHandle getHomeHandle() {
        EJBContainer ejbContainer = this.container;
        HomeHandleImpl homeHandle = null;
        RemoteBinding remoteBindingAnnotation = (RemoteBinding)ejbContainer.resolveAnnotation(RemoteBinding.class);
        if (remoteBindingAnnotation != null) {
            homeHandle = new HomeHandleImpl(ProxyFactoryHelper.getHomeJndiName((Container)this.container));
        }
        return homeHandle;
    }

    protected EJBMetaData getEjbMetaData() {
        RemoteBinding remoteBindingAnnotation;
        RemoteHome homeAnnotation;
        Class remote = null;
        Class home = null;
        Class<Object> pkClass = Object.class;
        HomeHandleImpl homeHandle = null;
        EJBContainer ejbContainer = this.container;
        Remote remoteAnnotation = (Remote)ejbContainer.resolveAnnotation(Remote.class);
        if (remoteAnnotation != null) {
            remote = remoteAnnotation.value()[0];
        }
        if ((homeAnnotation = (RemoteHome)ejbContainer.resolveAnnotation(RemoteHome.class)) != null) {
            home = homeAnnotation.value();
        }
        if ((remoteBindingAnnotation = (RemoteBinding)ejbContainer.resolveAnnotation(RemoteBinding.class)) != null) {
            homeHandle = new HomeHandleImpl(remoteBindingAnnotation.jndiBinding());
        }
        EJBMetaDataImpl metadata = new EJBMetaDataImpl(remote, home, pkClass, true, false, homeHandle);
        return metadata;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.containerGuid = in.readUTF();
        this.containerClusterUid = in.readUTF();
        this.isClustered = in.readBoolean();
        if (this.getContainer() == null) {
            throw new EJBException("Invalid (i.e. remote) invocation of local interface (null container) for " + this.containerGuid);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.containerGuid);
        out.writeUTF(this.containerClusterUid);
        out.writeBoolean(this.isClustered);
    }

    protected void ensureEjb21ViewComplete(Class<?> home, Class<?>[] localOrRemoteInterfaces) throws RuntimeException {
        assert (home == null || EJBHome.class.isAssignableFrom(home) || EJBLocalHome.class.isAssignableFrom(home));
        for (Class<?> localOrRemoteInterface : localOrRemoteInterfaces) {
            assert (EJBObject.class.isAssignableFrom(localOrRemoteInterface) || EJBLocalObject.class.isAssignableFrom(localOrRemoteInterface));
        }
        if (home != null && localOrRemoteInterfaces.length == 0) {
            throw new RuntimeException("EJBTHREE-1075: " + this.container.getBeanClassName() + " defines home" + " but provides no local/remote interfaces extending " + EJBLocalObject.class.getName() + "/" + EJBObject.class.getName() + "; EJB 2.1 view cannot be realized");
        }
        if (home == null && localOrRemoteInterfaces.length != 0) {
            throw new RuntimeException("EJBTHREE-1075: " + this.container.getBeanClassName() + " defines local/remote interfaces" + " but provides no home; EJB 2.1 view cannot be realized");
        }
    }
}

