/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import javax.ejb.RemoteHome;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.PojiProxy;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.remoting.IsLocalProxyFactoryInterceptor;
import org.jboss.ejb3.remoting.RemoteProxyFactory;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.stateful.BaseStatefulProxyFactory;
import org.jboss.ejb3.stateful.StatefulHandleImpl;
import org.jboss.ejb3.stateful.StatefulHomeRemoteProxy;
import org.jboss.ejb3.stateful.StatefulRemoteProxy;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulRemoteProxyFactory
extends BaseStatefulProxyFactory
implements RemoteProxyFactory {
    private static final Logger log = Logger.getLogger(StatefulRemoteProxyFactory.class);
    private RemoteBinding binding;
    private InvokerLocator locator;

    public StatefulRemoteProxyFactory(SessionContainer container, RemoteBinding binding) {
        super(container, binding.jndiBinding());
        this.binding = binding;
    }

    @Override
    protected Class<?>[] getInterfaces() {
        SessionContainer statefulContainer = (SessionContainer)this.getContainer();
        RemoteHome remoteHome = (RemoteHome)statefulContainer.resolveAnnotation(RemoteHome.class);
        boolean bindTogether = false;
        if (remoteHome != null && this.bindHomeAndBusinessTogether(statefulContainer)) {
            bindTogether = true;
        }
        HashSet<Class> remoteInterfaces = new HashSet<Class>();
        remoteInterfaces.addAll(Arrays.asList(ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces((Container)this.getContainer())));
        this.ensureEjb21ViewComplete(remoteHome == null ? null : remoteHome.value(), ProxyFactoryHelper.getRemoteInterfaces((Container)this.getContainer()));
        remoteInterfaces.add(JBossProxy.class);
        if (bindTogether) {
            remoteInterfaces.add(remoteHome.value());
        }
        return remoteInterfaces.toArray(new Class[0]);
    }

    protected boolean bindHomeAndBusinessTogether(SessionContainer container) {
        return ProxyFactoryHelper.getHomeJndiName((Container)container).equals(ProxyFactoryHelper.getRemoteJndiName((Container)container));
    }

    @Override
    public void init() throws Exception {
        super.init();
        String clientBindUrl = ProxyFactoryHelper.getClientBindUrl((RemoteBinding)this.binding);
        this.locator = new InvokerLocator(clientBindUrl);
    }

    @Override
    public void start() throws Exception {
        this.init();
        super.start();
        Class[] interfaces = new Class[]{ProxyFactory.class};
        String targetId = this.getTargetId();
        String clientBindUrl = ProxyFactoryHelper.getClientBindUrl((RemoteBinding)this.binding);
        Object factoryProxy = this.createPojiProxy(targetId, interfaces, clientBindUrl);
        log.debug((Object)("Binding proxy factory for " + this.getContainer().getEjbName() + " in JNDI at " + this.jndiName + "StatefulProxyFactory" + " with client bind url " + clientBindUrl));
        try {
            Util.rebind((Context)this.getContainer().getInitialContext(), (String)(this.jndiName + "StatefulProxyFactory"), (Object)factoryProxy);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind stateful remote proxy with ejb name " + this.getContainer().getEjbName() + " into JNDI under jndiName: " + this.getContainer().getInitialContext().getNameInNamespace() + "/" + this.jndiName + "StatefulProxyFactory");
            namingException.setRootCause(e);
            throw namingException;
        }
        assert (!Dispatcher.singleton.isRegistered((Object)targetId)) : targetId + " is already registered";
        Dispatcher.singleton.registerTarget((Object)targetId, (Object)this);
        SessionContainer statefulContainer = (SessionContainer)this.getContainer();
        RemoteHome remoteHome = (RemoteHome)statefulContainer.resolveAnnotation(RemoteHome.class);
        if (remoteHome != null && !this.bindHomeAndBusinessTogether(statefulContainer)) {
            Object homeProxy = this.createHomeProxy(remoteHome.value());
            String homeJndiName = ProxyFactoryHelper.getHomeJndiName((Container)this.getContainer());
            log.debug((Object)("Binding home proxy at " + homeJndiName));
            Util.rebind((Context)this.getContainer().getInitialContext(), (String)homeJndiName, (Object)homeProxy);
        }
    }

    @Override
    public void stop() throws Exception {
        Util.unbind((Context)this.getContainer().getInitialContext(), (String)(this.jndiName + "StatefulProxyFactory"));
        Dispatcher.singleton.unregisterTarget((Object)this.getTargetId());
        SessionContainer statefulContainer = (SessionContainer)this.getContainer();
        RemoteHome remoteHome = (RemoteHome)statefulContainer.resolveAnnotation(RemoteHome.class);
        if (remoteHome != null && !this.bindHomeAndBusinessTogether(statefulContainer)) {
            Util.unbind((Context)this.getContainer().getInitialContext(), (String)ProxyFactoryHelper.getHomeJndiName((Container)this.getContainer()));
        }
        super.stop();
    }

    public Object createHomeProxy(Class homeInterface) {
        try {
            AdviceStack stack;
            String containerId = this.getContainer().getObjectName().getCanonicalName();
            String stackName = "StatefulSessionClientInterceptors";
            if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
                stackName = this.binding.interceptorStack();
            }
            if ((stack = AspectManager.instance().getAdviceStack(stackName)) == null) {
                throw new RuntimeException("unable to find interceptor stack: " + stackName);
            }
            StatefulHomeRemoteProxy proxy = new StatefulHomeRemoteProxy(this.getContainer(), stack.createInterceptors((Advisor)this.getContainer(), null), this.locator);
            this.setEjb21Objects(proxy);
            Class[] intfs = new Class[]{homeInterface};
            return Proxy.newProxyInstance(this.getContainer().getBeanClass().getClassLoader(), intfs, (InvocationHandler)proxy);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object createProxy() {
        AdviceStack stack;
        String stackName = "StatefulSessionClientInterceptors";
        if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
            stackName = this.binding.interceptorStack();
        }
        if ((stack = AspectManager.instance().getAdviceStack(stackName)) == null) {
            throw new RuntimeException("unable to find interceptor stack: " + stackName);
        }
        StatefulRemoteProxy proxy = new StatefulRemoteProxy(this.getContainer(), stack.createInterceptors((Advisor)this.getContainer(), null), this.locator);
        this.setEjb21Objects(proxy);
        return this.constructProxy(proxy);
    }

    @Override
    protected StatefulHandleImpl getHandle() {
        StatefulHandleImpl handle = new StatefulHandleImpl();
        handle.jndiName = this.jndiName;
        return handle;
    }

    @Override
    public Object createProxy(Object id) {
        String stackName = "StatefulSessionClientInterceptors";
        if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
            stackName = this.binding.interceptorStack();
        }
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        StatefulRemoteProxy proxy = new StatefulRemoteProxy(this.getContainer(), stack.createInterceptors((Advisor)this.getContainer(), null), this.locator, id);
        this.setEjb21Objects(proxy);
        return this.constructProxy(proxy);
    }

    protected String getTargetId() {
        assert (this.jndiName != null) : "jndiName is null";
        return this.jndiName + "StatefulProxyFactory";
    }

    protected Object createPojiProxy(Object oid, Class[] interfaces, String uri) throws Exception {
        InvokerLocator locator = new InvokerLocator(uri);
        Interceptor[] interceptors = new Interceptor[]{IsLocalProxyFactoryInterceptor.singleton, InvokeRemoteInterceptor.singleton};
        PojiProxy proxy = new PojiProxy(oid, locator, interceptors);
        return Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (InvocationHandler)proxy);
    }
}

