/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.ejb.EJBException;
import org.jboss.aspects.asynch.AsynchMixin;
import org.jboss.aspects.asynch.AsynchProvider;
import org.jboss.aspects.asynch.FutureHolder;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.LocalProxy;
import org.jboss.ejb3.ProxyUtils;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.logging.Logger;

public class StatelessLocalProxy
extends LocalProxy {
    private static final long serialVersionUID = -3241008127518089831L;
    private static final Logger log = Logger.getLogger(StatelessLocalProxy.class);
    AsynchProvider provider;

    public StatelessLocalProxy() {
    }

    public StatelessLocalProxy(Container container) {
        super(container);
    }

    public StatelessLocalProxy(AsynchProvider provider, Container container) {
        super(container);
        this.provider = provider;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == AsynchProvider.class) {
            return this.provider.getFuture();
        }
        Object ret = ProxyUtils.handleCallLocally(proxy, this, method, args);
        if (ret != null) {
            return ret;
        }
        StatelessContainer container = (StatelessContainer)this.getContainer();
        if (container == null) {
            throw new EJBException("Invalid invocation of local interface (null container)");
        }
        return container.localInvoke(method, args, (FutureHolder)this.provider);
    }

    public Object getAsynchronousProxy(Object proxy) {
        Class[] infs = proxy.getClass().getInterfaces();
        if (!ProxyUtils.isAsynchronous(infs)) {
            Class[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
            AsynchMixin mixin = new AsynchMixin();
            StatelessLocalProxy handler = new StatelessLocalProxy((AsynchProvider)mixin, this.getContainer());
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)handler);
        }
        return proxy;
    }

    public String toString() {
        if (this.getContainer() == null) {
            return this.proxyName;
        }
        return this.getContainer().getEjbName();
    }
}

