/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.Local;
import javax.ejb.LocalHome;
import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import javax.jws.WebService;
import javax.management.ObjectName;
import org.jboss.aop.Advisor;
import org.jboss.ejb.LocalImpl;
import org.jboss.ejb.RemoteImpl;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.KernelAbstractionFactory;
import org.jboss.ejb3.annotation.JndiBindingPolicy;
import org.jboss.ejb3.annotation.LocalBinding;
import org.jboss.ejb3.annotation.LocalHomeBinding;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.annotation.RemoteBindings;
import org.jboss.ejb3.annotation.RemoteHomeBinding;
import org.jboss.ejb3.jndipolicy.DefaultJndiBindingPolicy;
import org.jboss.ejb3.jndipolicy.Ejb3DeploymentSummary;
import org.jboss.ejb3.jndipolicy.impl.PackagingBasedJndiBindingPolicy;
import org.jboss.ejb3.lang.ClassHelper;
import org.jboss.ejb3.service.ServiceContainer;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyFactoryHelper {
    private static final Logger log = Logger.getLogger(ProxyFactoryHelper.class);

    private static String getEndpointInterface(Container container) {
        WebService ws = (WebService)((EJBContainer)container).resolveAnnotation(WebService.class);
        if (ws != null) {
            return ws.endpointInterface();
        }
        return null;
    }

    public static Class<?>[] getLocalAndBusinessLocalInterfaces(Container container) {
        boolean isStateless;
        HashSet localAndBusinessLocalInterfaces = new HashSet();
        Class beanClass = container.getBeanClass();
        Local localAnnotation = ((EJBContainer)container).getAnnotation(Local.class);
        LocalHome localHomeAnnotation = ((EJBContainer)container).getAnnotation(LocalHome.class);
        Remote remoteAnnotation = ((EJBContainer)container).getAnnotation(Remote.class);
        Class<?>[] remoteAndBusinessRemoteInterfaces = ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(container);
        Set<Class<?>> businessInterfacesImplementedByBeanClass = ProxyFactoryHelper.getBusinessInterfaces(beanClass);
        Set<Class<?>> businessInterfacesDirectlyImplementedByBeanClass = ProxyFactoryHelper.getBusinessInterfaces(beanClass, false);
        boolean bl = isStateless = container instanceof StatelessContainer;
        if (localHomeAnnotation != null) {
            localAndBusinessLocalInterfaces.addAll(ProxyFactoryHelper.getReturnTypesFromCreateMethods(localHomeAnnotation.value(), isStateless));
        }
        for (Class<?> clazz : businessInterfacesImplementedByBeanClass) {
            if (!clazz.isAnnotationPresent(Local.class)) continue;
            localAndBusinessLocalInterfaces.add(clazz);
        }
        if (businessInterfacesDirectlyImplementedByBeanClass.size() == 1 && localAndBusinessLocalInterfaces.size() == 0) {
            Class<?> singleInterface = businessInterfacesDirectlyImplementedByBeanClass.iterator().next();
            if (remoteAnnotation == null && singleInterface.getAnnotation(Remote.class) == null) {
                Class[] returnValue = new Class[]{singleInterface};
                LocalImpl li = new LocalImpl(returnValue);
                ((EJBContainer)container).getAnnotations().addClassAnnotation(Local.class, (Object)li);
                return returnValue;
            }
        }
        if (localAnnotation != null) {
            if (localAnnotation.value() == null || localAnnotation.value().length == 0) {
                if (businessInterfacesImplementedByBeanClass.size() == 0) {
                    throw new RuntimeException("Use of empty @Local on bean " + container.getEjbName() + " and there are no valid business interfaces");
                }
                if (businessInterfacesImplementedByBeanClass.size() > 1) {
                    throw new RuntimeException("Use of empty @Local on bean " + container.getEjbName() + " with more than one default interface " + businessInterfacesImplementedByBeanClass);
                }
                if (remoteAnnotation == null) {
                    Class[] returnValue = businessInterfacesImplementedByBeanClass.toArray(new Class[0]);
                    LocalImpl li = new LocalImpl(returnValue);
                    ((EJBContainer)container).getAnnotations().addClassAnnotation(Local.class, (Object)li);
                    return returnValue;
                }
            } else {
                for (Class<?> clazz : localAnnotation.value()) {
                    localAndBusinessLocalInterfaces.add(clazz);
                }
                for (Class<?> clazz : businessInterfacesImplementedByBeanClass) {
                    if (!clazz.isAnnotationPresent(Local.class)) continue;
                    localAndBusinessLocalInterfaces.add(clazz);
                }
            }
        }
        if (localAndBusinessLocalInterfaces.size() > 0) {
            for (Class<?> clazz : remoteAndBusinessRemoteInterfaces) {
                for (Class clazz2 : localAndBusinessLocalInterfaces) {
                    if (!clazz2.equals(clazz)) continue;
                    throw new RuntimeException("@Remote and @Local may not both be specified on the same interface \"" + clazz.toString() + "\" per EJB3 Spec 4.6.7, Bullet 5.4");
                }
            }
            Class[] rtn = localAndBusinessLocalInterfaces.toArray(new Class[0]);
            localAnnotation = new LocalImpl(rtn);
            ((EJBContainer)container).getAnnotations().addClassAnnotation(Local.class, (Object)localAnnotation);
            return rtn;
        }
        String endpoint = ProxyFactoryHelper.getEndpointInterface(container);
        if (remoteAndBusinessRemoteInterfaces.length == 0 && endpoint == null) {
            throw new RuntimeException("Bean Class " + beanClass.getName() + " has no local, webservice, or remote interfaces defined and does not implement at least one business interface: " + container.getEjbName());
        }
        return new Class[0];
    }

    public static Set<Class<?>> getBusinessInterfaces(Class<?> beanClass) {
        return ProxyFactoryHelper.getBusinessInterfaces(beanClass, new HashSet());
    }

    public static Set<Class<?>> getBusinessInterfaces(Class<?> beanClass, boolean includeSupers) {
        return ProxyFactoryHelper.getBusinessInterfaces(beanClass, new HashSet(), includeSupers);
    }

    private static Set<Class<?>> getBusinessInterfaces(Class<?> beanClass, Set<Class<?>> interfaces) {
        return ProxyFactoryHelper.getBusinessInterfaces(beanClass, interfaces, true);
    }

    private static Set<Class<?>> getBusinessInterfaces(Class<?> beanClass, Set<Class<?>> interfaces, boolean includeSupers) {
        for (Class<?> intf : beanClass.getInterfaces()) {
            if (intf.equals(Externalizable.class) || intf.equals(Serializable.class) || intf.getName().startsWith("javax.ejb") || intf.getName().startsWith("org.jboss.aop")) continue;
            interfaces.add(intf);
        }
        if (!includeSupers || beanClass.getSuperclass() == null) {
            return interfaces;
        }
        return ProxyFactoryHelper.getBusinessInterfaces(beanClass.getSuperclass(), interfaces);
    }

    public static Class<?> getLocalHomeInterface(Container container) {
        LocalHome li = ((EJBContainer)container).getAnnotation(LocalHome.class);
        if (li != null) {
            return li.value();
        }
        return null;
    }

    public static Class<?> getRemoteHomeInterface(Container container) {
        RemoteHome li = ((EJBContainer)container).getAnnotation(RemoteHome.class);
        if (li != null) {
            return li.value();
        }
        return null;
    }

    public static boolean publishesInterface(Container container, Class<?> businessInterface) {
        Class<?>[] locals;
        Class<?>[] remotes;
        if (!(container instanceof SessionContainer)) {
            return false;
        }
        for (Class<?> intf : remotes = ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(container)) {
            if (!intf.getName().equals(businessInterface.getName())) continue;
            return true;
        }
        Class<?> remoteHome = ProxyFactoryHelper.getRemoteHomeInterface(container);
        if (remoteHome != null && businessInterface.getName().equals(remoteHome.getName())) {
            return true;
        }
        for (Class<?> clazz : locals = ProxyFactoryHelper.getLocalAndBusinessLocalInterfaces(container)) {
            if (!clazz.getName().equals(businessInterface.getName())) continue;
            return true;
        }
        Class<?> localHome = ProxyFactoryHelper.getLocalHomeInterface(container);
        return localHome != null && businessInterface.getName().equals(localHome.getName());
    }

    public static String getJndiName(Container container, Class<?> businessInterface) {
        Class<?>[] locals;
        Class<?> localHome;
        Class<?>[] remotes;
        assert (container != null) : "container is null";
        assert (businessInterface != null) : "businessInterface is null";
        String jndiName = null;
        boolean isHome = false;
        boolean isLocal = false;
        for (Class<?> clazz : remotes = ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(container)) {
            if (!clazz.getName().equals(businessInterface.getName())) continue;
            RemoteBindings bindings = ((EJBContainer)container).getAnnotation(RemoteBindings.class);
            if (bindings != null) {
                return bindings.value()[0].jndiBinding();
            }
            RemoteBinding binding = ((EJBContainer)container).getAnnotation(RemoteBinding.class);
            if (binding == null) continue;
            return binding.jndiBinding();
        }
        Class<?> remoteHome = ProxyFactoryHelper.getRemoteHomeInterface(container);
        if (remoteHome != null && businessInterface.getName().equals(remoteHome.getName())) {
            RemoteHomeBinding binding = ((EJBContainer)container).getAnnotation(RemoteHomeBinding.class);
            if (binding != null) {
                return binding.jndiBinding();
            }
            isHome = true;
        }
        if ((localHome = ProxyFactoryHelper.getLocalHomeInterface(container)) != null && businessInterface.getName().equals(localHome.getName())) {
            LocalHomeBinding binding = ((EJBContainer)container).getAnnotation(LocalHomeBinding.class);
            if (binding != null) {
                return binding.jndiBinding();
            }
            isHome = true;
            isLocal = true;
        }
        for (Class<?> clazz : locals = ProxyFactoryHelper.getLocalAndBusinessLocalInterfaces(container)) {
            if (!clazz.getName().equals(businessInterface.getName())) continue;
            LocalBinding binding = ((EJBContainer)container).getAnnotation(LocalBinding.class);
            if (binding != null) {
                return binding.jndiBinding();
            }
            isLocal = true;
        }
        if (jndiName == null) {
            log.debug((Object)("JNDI name has not been explicitly set for EJB " + container.getEjbName() + ", interface " + businessInterface.getName()));
            Ejb3DeploymentSummary summary = ProxyFactoryHelper.getDeploymentSummaryFromContainer(container);
            summary.setHome(isHome);
            summary.setLocal(isLocal);
            jndiName = ProxyFactoryHelper.getJndiBindingPolicy(container).getJndiName(summary);
        }
        return jndiName;
    }

    public static Class<?>[] getLocalInterfaces(Container container) {
        return ProxyFactoryHelper.getInterfacesAssignableFromClass(ProxyFactoryHelper.getLocalAndBusinessLocalInterfaces(container), EJBLocalObject.class, true);
    }

    public static Class<?>[] getRemoteInterfaces(Container container) {
        return ProxyFactoryHelper.getInterfacesAssignableFromClass(ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(container), EJBObject.class, true);
    }

    public static Class<?>[] getLocalBusinessInterfaces(Container container) {
        return ProxyFactoryHelper.getInterfacesAssignableFromClass(ProxyFactoryHelper.getLocalAndBusinessLocalInterfaces(container), EJBLocalObject.class, false);
    }

    public static Class<?>[] getRemoteBusinessInterfaces(Container container) {
        return ProxyFactoryHelper.getInterfacesAssignableFromClass(ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(container), EJBObject.class, false);
    }

    private static Class<?>[] getInterfacesAssignableFromClass(Class<?>[] interfaces, Class<?> clazz, boolean assignable) {
        ArrayList subset = new ArrayList();
        for (Class<?> interfaze : interfaces) {
            if (assignable && clazz.isAssignableFrom(interfaze)) {
                subset.add(interfaze);
            }
            if (assignable || clazz.isAssignableFrom(interfaze)) continue;
            subset.add(interfaze);
        }
        return subset.toArray(new Class[0]);
    }

    public static Class<?>[] getRemoteAndBusinessRemoteInterfaces(Container container) {
        Remote remoteAnnotation = ((EJBContainer)container).getAnnotation(Remote.class);
        RemoteHome remoteHomeAnnotation = ((EJBContainer)container).getAnnotation(RemoteHome.class);
        HashSet<Class> remoteAndRemoteBusinessInterfaces = new HashSet<Class>();
        Class beanClass = container.getBeanClass();
        boolean isStateless = container instanceof StatelessContainer;
        Class[] businessInterfaces = ProxyFactoryHelper.getBusinessInterfaces(beanClass).toArray(new Class[0]);
        if (remoteHomeAnnotation != null) {
            remoteAndRemoteBusinessInterfaces.addAll(ProxyFactoryHelper.getReturnTypesFromCreateMethods(remoteHomeAnnotation.value(), isStateless));
        }
        if (remoteAnnotation == null) {
            for (Class clazz : businessInterfaces) {
                if (!clazz.isAnnotationPresent(Remote.class)) continue;
                remoteAndRemoteBusinessInterfaces.add(clazz);
            }
        } else if (remoteAnnotation.value().length > 0) {
            for (Class clazz : remoteAnnotation.value()) {
                remoteAndRemoteBusinessInterfaces.add(clazz);
            }
        } else {
            if (businessInterfaces.length == 0) {
                throw new RuntimeException("Use of empty @Remote on bean " + container.getEjbName() + " and there are no valid business interfaces");
            }
            if (businessInterfaces.length > 1) {
                throw new RuntimeException("Use of empty @Remote on bean " + container.getEjbName() + " with more than one default interface " + businessInterfaces);
            }
            Class[] rtn = new Class[]{businessInterfaces[0]};
            remoteAnnotation = new RemoteImpl(rtn);
            ((EJBContainer)container).getAnnotations().addClassAnnotation(Remote.class, (Object)remoteAnnotation);
            return rtn;
        }
        if (remoteAndRemoteBusinessInterfaces.size() > 0) {
            Class[] remotesArray = remoteAndRemoteBusinessInterfaces.toArray(new Class[remoteAndRemoteBusinessInterfaces.size()]);
            remoteAnnotation = new RemoteImpl(remotesArray);
            ((Advisor)container).getAnnotations().addClassAnnotation(Remote.class, (Object)remoteAnnotation);
            return remoteAnnotation.value();
        }
        return new Class[0];
    }

    private static Set<Class<?>> getReturnTypesFromCreateMethods(Class<?> homeInterface, boolean isStateless) {
        assert (EJBHome.class.isAssignableFrom(homeInterface) || EJBLocalHome.class.isAssignableFrom(homeInterface));
        if (!EJBHome.class.isAssignableFrom(homeInterface) && !EJBLocalHome.class.isAssignableFrom(homeInterface)) {
            throw new RuntimeException("Declared EJB 2.1 Home Interface " + homeInterface.getName() + " does not extend " + EJBHome.class.getName() + " or " + EJBLocalHome.class.getName() + " as required by EJB 3.0 Core Specification 4.6.8 and 4.6.10");
        }
        HashSet types = new HashSet();
        List<Method> createMethods = null;
        if (isStateless) {
            String specViolationErrorMessage = "EJB 3.0 Specification Violation (4.6.8 Bullet 4, 4.6.10 Bullet 4): \"A stateless session bean must define exactly one create method with no arguments.\"; found in " + homeInterface.getName();
            createMethods = new ArrayList<Method>();
            try {
                createMethods.add(homeInterface.getMethod("create", new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(specViolationErrorMessage);
            }
            if (createMethods.size() > 1) {
                throw new RuntimeException(specViolationErrorMessage);
            }
        } else {
            createMethods = ClassHelper.getAllMethodsByPrefix(homeInterface, "create");
        }
        if (createMethods.size() == 0) {
            throw new RuntimeException("EJB 3.0 Core Specification Violation (4.6.8 Bullet 5): EJB2.1 Home Interface " + homeInterface + " does not declare a 'create<METHOD>' method");
        }
        for (Method method : createMethods) {
            types.add(method.getReturnType());
        }
        return types;
    }

    public static String getClientBindUrl(RemoteBinding binding) throws Exception {
        String clientBindUrl = binding.clientBindUrl();
        if (clientBindUrl.trim().length() == 0) {
            ObjectName connectionON = new ObjectName("jboss.remoting:type=Connector,name=DefaultEjb3Connector,handler=ejb3");
            KernelAbstraction kernelAbstraction = KernelAbstractionFactory.getInstance();
            try {
                clientBindUrl = (String)kernelAbstraction.getAttribute(connectionON, "InvokerLocator");
                if (clientBindUrl == null) {
                    clientBindUrl = "socket://0.0.0.0:3873";
                }
            }
            catch (Exception e) {
                clientBindUrl = "socket://0.0.0.0:3873";
            }
        }
        return clientBindUrl;
    }

    public static String getHomeJndiName(Container container) {
        Advisor advisor = (Advisor)container;
        RemoteHomeBinding binding = (RemoteHomeBinding)advisor.resolveAnnotation(RemoteHomeBinding.class);
        if (binding != null) {
            return binding.jndiBinding();
        }
        return ProxyFactoryHelper.getJndiBindingPolicy(container).getDefaultRemoteHomeJndiName(ProxyFactoryHelper.getDeploymentSummaryFromContainer(container));
    }

    public static String getLocalHomeJndiName(Container container) {
        Advisor advisor = (Advisor)container;
        LocalHomeBinding binding = (LocalHomeBinding)advisor.resolveAnnotation(LocalHomeBinding.class);
        if (binding != null) {
            return binding.jndiBinding();
        }
        return ProxyFactoryHelper.getJndiBindingPolicy(container).getDefaultLocalHomeJndiName(ProxyFactoryHelper.getDeploymentSummaryFromContainer(container));
    }

    public static String getLocalJndiName(Container container) {
        return ProxyFactoryHelper.getLocalJndiName(container, true);
    }

    private static String getLocalJndiName(Container container, boolean conflictCheck) {
        Advisor advisor = (Advisor)container;
        LocalBinding localBinding = (LocalBinding)advisor.resolveAnnotation(LocalBinding.class);
        if (localBinding == null) {
            String name = ProxyFactoryHelper.getJndiBindingPolicy(container).getDefaultLocalJndiName(ProxyFactoryHelper.getDeploymentSummaryFromContainer(container));
            if (conflictCheck) {
                ProxyFactoryHelper.checkForJndiNamingConflict(container);
            }
            return name;
        }
        return localBinding.jndiBinding();
    }

    public static String getRemoteJndiName(Container container) {
        return ProxyFactoryHelper.getRemoteJndiName(container, true);
    }

    public static String getRemoteJndiName(Container container, boolean check) {
        Advisor advisor = (Advisor)container;
        RemoteBinding binding = (RemoteBinding)advisor.resolveAnnotation(RemoteBinding.class);
        return ProxyFactoryHelper.getRemoteJndiName(container, binding);
    }

    private static void checkForJndiNamingConflict(Container container) {
        if (((Advisor)container).resolveAnnotation(Local.class) != null) {
            Ejb3DeploymentSummary summary = ProxyFactoryHelper.getDeploymentSummaryFromContainer(container);
            String localJndiName = ProxyFactoryHelper.getJndiBindingPolicy(container).getDefaultLocalJndiName(summary);
            String remoteJndiName = ProxyFactoryHelper.getJndiBindingPolicy(container).getDefaultRemoteJndiName(summary);
            String ejbName = container.getEjbName();
            if (localJndiName.equals(remoteJndiName)) {
                throw new EJBException("Conflict between default jndi name " + remoteJndiName + " for both remote and local for ejb-name:" + ejbName + ", bean class=" + container.getBeanClass());
            }
        }
    }

    private static String getRemoteJndiName(Container container, RemoteBinding binding) {
        return ProxyFactoryHelper.getRemoteJndiName(container, binding, true);
    }

    public static String getRemoteJndiName(Container container, RemoteBinding binding, boolean conflictCheck) {
        String jndiName = null;
        if (binding == null || binding.jndiBinding() == null || binding.jndiBinding().equals("")) {
            jndiName = ProxyFactoryHelper.getDefaultRemoteJndiName(container);
            if (conflictCheck) {
                ProxyFactoryHelper.checkForJndiNamingConflict(container);
            }
        } else {
            jndiName = binding.jndiBinding();
        }
        return jndiName;
    }

    public static String getDefaultRemoteJndiName(Container container) {
        return ProxyFactoryHelper.getJndiBindingPolicy(container).getDefaultRemoteJndiName(ProxyFactoryHelper.getDeploymentSummaryFromContainer(container));
    }

    private static DefaultJndiBindingPolicy getJndiBindingPolicy(Container container) {
        EJBContainer ejbContainer = (EJBContainer)container;
        JndiBindingPolicy bindingPolicy = ejbContainer.getAnnotation(JndiBindingPolicy.class);
        Class<PackagingBasedJndiBindingPolicy> policy = null;
        if (bindingPolicy != null) {
            policy = bindingPolicy.policy();
        } else {
            Class<PackagingBasedJndiBindingPolicy> policyClass = PackagingBasedJndiBindingPolicy.class;
            log.warn((Object)("No default JNDI Binding Policy Defined (see ejb3-interceptors-aop.xml for example); defaulting to " + policyClass.getName()));
            policy = policyClass;
        }
        log.debug((Object)("Obtaining JNDI name from policy " + policy.getName()));
        try {
            return (DefaultJndiBindingPolicy)policy.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not instanciate JNDI Binding Policy: " + policy.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Ejb3DeploymentSummary getDeploymentSummaryFromContainer(Container container) {
        DeploymentScope scope;
        Ejb3DeploymentSummary summary = new Ejb3DeploymentSummary();
        summary.setEjbName(container.getEjbName());
        summary.setService(container instanceof ServiceContainer);
        summary.setStateful(container instanceof StatefulContainer);
        summary.setDeploymentName(((EJBContainer)container).getDeployment().getName());
        summary.setBeanClass(container.getBeanClass());
        if (container instanceof EJBContainer && (scope = ((EJBContainer)container).getDeployment().getEar()) != null) {
            summary.setDeploymentScopeBaseName(scope.getBaseName());
        }
        return summary;
    }
}

