/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.ejb3.NonSerializableFactory;
import org.jboss.naming.Util;

public class JndiBinder {
    private String bindTo;
    private Object target;
    private boolean serializable;
    private Hashtable properties;

    public void setBindTo(String bindTo) {
        this.bindTo = bindTo;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setSerializable(boolean serializable) {
        this.serializable = serializable;
    }

    public void setJndiProperties(Hashtable properties) {
        this.properties = properties;
    }

    public void start() throws Exception {
        InitialContext ctx = InitialContextFactory.getInitialContext(this.properties);
        try {
            if (this.serializable) {
                Util.rebind((Context)ctx, (String)this.bindTo, (Object)this.target);
            } else {
                NonSerializableFactory.rebind(ctx, this.bindTo, this.target);
            }
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind JndiBinder service into JNDI under jndiName:" + ctx.getNameInNamespace() + "/" + this.bindTo);
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    public void stop() throws Exception {
        InitialContext ctx = InitialContextFactory.getInitialContext(this.properties);
        if (this.serializable) {
            Util.unbind((Context)ctx, (String)this.bindTo);
        } else {
            NonSerializableFactory.unbind(ctx, this.bindTo);
        }
    }
}

